/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.HttpExchange;
import io.muserver.MuHandler;
import io.muserver.MuServerImpl;
import io.muserver.MuStatsImpl;
import io.muserver.NettyRequestAdapter;
import io.muserver.NettyResponseAdaptor;
import io.muserver.ResponseCompleteListener;
import io.muserver.ResponseInfo;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.RedirectionException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(NettyHandlerAdapter.class);
    private final List<MuHandler> muHandlers;
    private final ExecutorService executor;
    private final List<ResponseCompleteListener> completeListeners;

    NettyHandlerAdapter(ExecutorService executor, List<MuHandler> muHandlers, List<ResponseCompleteListener> completeListeners) {
        this.executor = executor;
        this.muHandlers = muHandlers;
        this.completeListeners = completeListeners;
    }

    void onHeaders(HttpExchange muCtx) {
        this.executor.execute(() -> {
            if (muCtx.state().endState()) {
                return;
            }
            NettyRequestAdapter request = muCtx.request;
            NettyResponseAdaptor response = muCtx.response;
            try {
                MuHandler muHandler;
                boolean handled = false;
                Iterator<MuHandler> iterator = this.muHandlers.iterator();
                while (iterator.hasNext() && !(handled = (muHandler = iterator.next()).handle(request, response))) {
                    if (!request.isAsync()) continue;
                    throw new IllegalStateException(muHandler.getClass() + " returned false however this is not allowed after starting to handle a request asynchronously.");
                }
                if (!handled) {
                    throw new NotFoundException();
                }
                if (!request.isAsync() && !response.outputState().endState()) {
                    response.flushAndCloseOutputStream();
                    muCtx.block(muCtx::complete);
                }
            }
            catch (Throwable ex) {
                NettyHandlerAdapter.useCustomExceptionHandlerOrFireIt(muCtx, ex);
            }
        });
    }

    static void useCustomExceptionHandlerOrFireIt(HttpExchange exchange, Throwable ex) {
        MuServerImpl server = (MuServerImpl)exchange.request.server();
        try {
            if (server.unhandledExceptionHandler != null && !(ex instanceof RedirectionException) && server.unhandledExceptionHandler.handle(exchange.request, exchange.response, ex)) {
                exchange.response.flushAndCloseOutputStream();
                exchange.block(exchange::complete);
            } else {
                exchange.fireException(ex);
            }
        }
        catch (Throwable handlerException) {
            exchange.fireException(handlerException);
        }
    }

    void onResponseComplete(ResponseInfo info, MuStatsImpl serverStats, MuStatsImpl connectionStats) {
        connectionStats.onRequestEnded(info.request());
        serverStats.onRequestEnded(info.request());
        if (this.completeListeners != null) {
            for (ResponseCompleteListener listener : this.completeListeners) {
                try {
                    listener.onComplete(info);
                }
                catch (Exception e) {
                    log.error("Error from completion listener", (Throwable)e);
                }
            }
        }
    }
}

