/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Mutils;
import io.muserver.ParseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParameterizedHeader {
    private final Map<String, String> parameters;

    private ParameterizedHeader(Map<String, String> parameters) {
        Mutils.notNull("parameters", parameters);
        this.parameters = parameters;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String parameter(String name) {
        return this.parameters.get(name);
    }

    public String parameter(String name, String defaultValue) {
        return this.parameters.getOrDefault(name, defaultValue);
    }

    public boolean hasParameter(String name) {
        return this.parameters.containsKey(name);
    }

    public List<String> parameterNames() {
        return new ArrayList<String>(this.parameters.keySet());
    }

    public static ParameterizedHeader fromString(String input) {
        if (input == null || input.trim().isEmpty()) {
            return new ParameterizedHeader(Collections.emptyMap());
        }
        StringBuilder buffer = new StringBuilder();
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        State state = State.PARAM_NAME;
        String paramName = null;
        boolean isQuotedString = false;
        for (int i = 0; i < input.length(); ++i) {
            boolean isFirst;
            char c = input.charAt(i);
            if (state == State.PARAM_NAME) {
                if (c == ',') {
                    if (buffer.length() <= 0) continue;
                    parameters.put(buffer.toString(), null);
                    buffer.setLength(0);
                    paramName = null;
                    continue;
                }
                if (c == '=') {
                    paramName = buffer.toString();
                    if (paramName.isEmpty()) {
                        throw new IllegalArgumentException("Nameless values not allowed");
                    }
                    buffer.setLength(0);
                    state = State.PARAM_VALUE;
                    continue;
                }
                if (ParseUtils.isTChar(c)) {
                    buffer.append(c);
                    continue;
                }
                if (ParseUtils.isOWS(c)) continue;
                throw new IllegalArgumentException("Got ascii " + c + " while in " + (Object)((Object)state));
            }
            boolean bl = isFirst = !isQuotedString && buffer.length() == 0;
            if (isFirst && ParseUtils.isOWS(c)) continue;
            if (isFirst && c == '\"') {
                isQuotedString = true;
                continue;
            }
            if (isQuotedString) {
                char lastChar = input.charAt(i - 1);
                if (c == '\\') continue;
                if (lastChar == '\\') {
                    buffer.append(c);
                    continue;
                }
                if (c == '\"') {
                    isQuotedString = false;
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (c == ',') {
                parameters.put(paramName, buffer.toString());
                buffer.setLength(0);
                paramName = null;
                state = State.PARAM_NAME;
                continue;
            }
            if (ParseUtils.isTChar(c)) {
                buffer.append(c);
                continue;
            }
            if (ParseUtils.isOWS(c)) continue;
            throw new IllegalArgumentException("Got character code " + c + " (" + c + ") while parsing parameter value");
        }
        if (state == State.PARAM_VALUE) {
            parameters.put(paramName, buffer.toString());
            buffer.setLength(0);
        } else if (buffer.length() > 0) {
            parameters.put(buffer.toString(), null);
        }
        return new ParameterizedHeader(parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> parameters = this.parameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            String value = entry.getValue();
            if (value == null) continue;
            sb.append('=').append(ParseUtils.quoteIfNeeded(value));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedHeader that = (ParameterizedHeader)o;
        return Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }

    private static enum State {
        PARAM_NAME,
        PARAM_VALUE;

    }
}

