/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Mutils;
import io.muserver.ParseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ParameterizedHeaderWithValue {
    private final String value;
    private final Map<String, String> parameters;

    ParameterizedHeaderWithValue(String value, Map<String, String> parameters) {
        Mutils.notNull("value", value);
        Mutils.notNull("parameters", parameters);
        this.value = value;
        this.parameters = parameters;
    }

    public String value() {
        return this.value;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public String parameter(String name) {
        return this.parameters.get(name);
    }

    public String parameter(String name, String defaultValue) {
        return this.parameters.getOrDefault(name, defaultValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<ParameterizedHeaderWithValue> fromString(String input) {
        if (input == null || input.trim().isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder buffer = new StringBuilder();
        ArrayList<ParameterizedHeaderWithValue> results = new ArrayList<ParameterizedHeaderWithValue>();
        int i = 0;
        while (i < input.length()) {
            String value = null;
            LinkedHashMap<String, String> parameters = null;
            State state = State.VALUE;
            String paramName = null;
            boolean isQuotedString = false;
            while (i < input.length()) {
                char c = input.charAt(i);
                if (state == State.VALUE) {
                    if (c == ';') {
                        value = buffer.toString().trim();
                        buffer.setLength(0);
                        state = State.PARAM_NAME;
                    } else {
                        if (c == ',') {
                            ++i;
                            break;
                        }
                        if (!ParseUtils.isVChar(c) && !ParseUtils.isOWS(c)) throw new IllegalArgumentException("Got ascii " + c + " while in " + (Object)((Object)state) + " at position " + i);
                        buffer.append(c);
                    }
                } else if (state == State.PARAM_NAME) {
                    if (c == ',' && buffer.length() == 0) {
                        ++i;
                        break;
                    }
                    if (c == '=') {
                        paramName = buffer.toString();
                        buffer.setLength(0);
                        state = State.PARAM_VALUE;
                    } else if (ParseUtils.isTChar(c)) {
                        buffer.append(c);
                    } else {
                        if (!ParseUtils.isOWS(c)) throw new IllegalArgumentException("Got ascii " + c + " while in " + (Object)((Object)state));
                        if (buffer.length() > 0) {
                            throw new IllegalArgumentException("Got whitespace in parameter name while in " + (Object)((Object)state) + " - header was " + buffer);
                        }
                    }
                } else {
                    boolean isFirst;
                    boolean bl = isFirst = !isQuotedString && buffer.length() == 0;
                    if (!isFirst || !ParseUtils.isOWS(c)) {
                        if (isFirst && c == '\"') {
                            isQuotedString = true;
                        } else if (isQuotedString) {
                            char lastChar = input.charAt(i - 1);
                            if (c != '\\') {
                                if (lastChar == '\\') {
                                    buffer.append(c);
                                } else if (c == '\"') {
                                    isQuotedString = false;
                                } else {
                                    buffer.append(c);
                                }
                            }
                        } else if (ParseUtils.isTChar(c)) {
                            buffer.append(c);
                        } else if (c == ';') {
                            if (parameters == null) {
                                parameters = new LinkedHashMap();
                            }
                            parameters.put(paramName, buffer.toString());
                            buffer.setLength(0);
                            paramName = null;
                            state = State.PARAM_NAME;
                        } else if (!ParseUtils.isOWS(c)) {
                            if (c != ',') throw new IllegalArgumentException("Got character code " + c + " (" + c + ") while parsing parameter value");
                            ++i;
                            break;
                        }
                    }
                }
                ++i;
            }
            switch (state) {
                case VALUE: {
                    value = buffer.toString().trim();
                    buffer.setLength(0);
                    break;
                }
                case PARAM_VALUE: {
                    if (parameters == null) {
                        parameters = new LinkedHashMap<String, String>();
                    }
                    parameters.put(paramName, buffer.toString());
                    buffer.setLength(0);
                    break;
                }
                default: {
                    if (buffer.length() <= 0) break;
                    throw new IllegalArgumentException("Unexpected ending point at state " + (Object)((Object)state) + " for " + input);
                }
            }
            results.add(new ParameterizedHeaderWithValue(value, parameters == null ? Collections.emptyMap() : parameters));
        }
        return results;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.value());
        Map<String, String> parameters = this.parameters();
        parameters.forEach((key, value) -> sb.append(';').append((String)key).append('=').append(ParseUtils.quoteIfNeeded(value)));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterizedHeaderWithValue that = (ParameterizedHeaderWithValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.parameters);
    }

    private static enum State {
        VALUE,
        PARAM_NAME,
        PARAM_VALUE;

    }
}

