/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;

class PreReader
extends ChannelDuplexHandler {
    private Object pendingMsg;
    private boolean wantsToRead = false;

    PreReader() {
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().config().setAutoRead(false);
        ctx.read();
        super.handlerAdded(ctx);
    }

    private void sendItMaybe(ChannelHandlerContext ctx) {
        Object msg;
        if (this.wantsToRead && (msg = this.pendingMsg) != null) {
            this.pendingMsg = null;
            this.wantsToRead = false;
            ctx.fireChannelRead(msg);
            ReferenceCountUtil.release((Object)msg);
            ctx.read();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ReferenceCountUtil.retain((Object)msg);
        this.pendingMsg = msg;
        this.sendItMaybe(ctx);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        this.wantsToRead = true;
        ctx.executor().submit(() -> this.sendItMaybe(ctx));
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.pendingMsg != null) {
            ReferenceCountUtil.release((Object)this.pendingMsg);
            ctx.fireChannelRead(this.pendingMsg);
            this.pendingMsg = null;
        }
        super.channelUnregistered(ctx);
    }
}

