/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Mutils;
import io.muserver.RateLimit;
import io.muserver.RateLimitRejectionAction;
import java.util.concurrent.TimeUnit;

public class RateLimitBuilder {
    private long rate = 100L;
    private long per = 1L;
    private TimeUnit perUnit = TimeUnit.SECONDS;
    private String bucket;
    private RateLimitRejectionAction action = RateLimitRejectionAction.SEND_429;

    public RateLimitBuilder withRate(long rate) {
        if (rate < 1L) {
            throw new IllegalArgumentException("Invalid rate (" + rate + ") for the rate limit");
        }
        this.rate = rate;
        return this;
    }

    public RateLimitBuilder withWindow(long period, TimeUnit unit) {
        if (period < 1L) {
            throw new IllegalArgumentException("Invalid period (" + period + ") for the rate limit");
        }
        Mutils.notNull("unit", (Object)unit);
        this.per = period;
        this.perUnit = unit;
        return this;
    }

    public RateLimitBuilder withBucket(String name) {
        this.bucket = name;
        return this;
    }

    public RateLimitBuilder withRejectionAction(RateLimitRejectionAction action) {
        Mutils.notNull("action", (Object)action);
        this.action = action;
        return this;
    }

    public static RateLimitBuilder rateLimit() {
        return new RateLimitBuilder();
    }

    public RateLimit build() {
        return new RateLimit(this.bucket, this.rate, this.action, this.per, this.perUnit);
    }
}

