/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuRequest;
import io.muserver.RateLimit;
import io.muserver.RateLimitRejectionAction;
import io.muserver.RateLimitSelector;
import io.muserver.RateLimiter;
import io.netty.util.HashedWheelTimer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RateLimiterImpl
implements RateLimiter {
    private final Logger log = LoggerFactory.getLogger(RateLimiterImpl.class);
    private final RateLimitSelector selector;
    private final ConcurrentHashMap<String, AtomicLong> map = new ConcurrentHashMap();
    private final HashedWheelTimer timer;

    RateLimiterImpl(RateLimitSelector selector, HashedWheelTimer timer) {
        this.selector = selector;
        this.timer = timer;
    }

    boolean record(MuRequest request) {
        RateLimit rateLimit = this.selector.select(request);
        if (rateLimit == null || rateLimit.bucket == null) {
            return true;
        }
        String name = rateLimit.bucket;
        AtomicLong counter = this.map.computeIfAbsent(name, s -> new AtomicLong(0L));
        long curVal = counter.get();
        if (curVal >= rateLimit.allowed) {
            this.log.info("Rate limit for " + name + " exceeded. Action: " + (Object)((Object)rateLimit.action));
            if (rateLimit.action == RateLimitRejectionAction.SEND_429) {
                return false;
            }
        } else {
            counter.incrementAndGet();
            this.timer.newTimeout(timeout -> {
                long newVal = counter.decrementAndGet();
                if (newVal <= 0L) {
                    this.map.remove(name);
                }
            }, rateLimit.per, rateLimit.perUnit);
        }
        return true;
    }

    @Override
    public Map<String, Long> currentBuckets() {
        HashMap<String, Long> copy = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> entry : this.map.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().longValue());
        }
        return Collections.unmodifiableMap(copy);
    }

    @Override
    public RateLimitSelector selector() {
        return this.selector;
    }

    public String toString() {
        return "RateLimiterImpl{buckets=" + this.map + '}';
    }
}

