/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.DoneCallback;
import io.muserver.FormRequestBodyReader;
import io.muserver.HeaderNames;
import io.muserver.HeaderValues;
import io.muserver.MuUploadedFile;
import io.muserver.Mutils;
import io.muserver.NettyRequestAdapter;
import io.muserver.NettyRequestParameters;
import io.muserver.RequestBodyListener;
import io.muserver.RequestParameters;
import io.muserver.UploadedFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http2.Http2Exception;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestBodyReader {
    private final CompletableFuture<Throwable> future = new CompletableFuture();
    private final AtomicLong bytes = new AtomicLong();
    final long maxSize;

    long receivedBytes() {
        return this.bytes.get();
    }

    protected RequestBodyReader(long maxSize) {
        this.maxSize = maxSize;
    }

    boolean completed() {
        return this.future.isDone();
    }

    protected Throwable currentError() {
        return this.future.getNow(null);
    }

    void onCancelled(Throwable cause) {
        this.future.complete(cause);
    }

    final void onRequestBodyRead(ByteBuf content, boolean last, DoneCallback callback) {
        try {
            long soFar = this.bytes.addAndGet(content.readableBytes());
            if (soFar > this.maxSize) {
                throw new ClientErrorException(RequestBodyReader.closingResponse(413, "The request body was too large"));
            }
            this.onRequestBodyRead0(content, last, error -> {
                if (error != null) {
                    this.future.complete(error);
                } else if (last) {
                    this.future.complete(null);
                }
                callback.onComplete(error);
            });
        }
        catch (Exception e) {
            try {
                callback.onComplete(e);
                this.future.complete(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected abstract void onRequestBodyRead0(ByteBuf var1, boolean var2, DoneCallback var3);

    void blockUntilFullyRead() throws IOException {
        Throwable throwable;
        try {
            throwable = this.future.get(1L, TimeUnit.HOURS);
            if (throwable instanceof Http2Exception.StreamException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof TimeoutException) {
                throw new ClientErrorException(RequestBodyReader.closingResponse(408, "Idle time out reading request body"));
            }
            if (throwable instanceof WebApplicationException) {
                throw (WebApplicationException)throwable;
            }
        }
        catch (ExecutionException e) {
            throwable = Mutils.coalesce(e.getCause(), e);
        }
        catch (TimeoutException e) {
            throw new IOException("Timed out");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Interrupted while reading request body");
        }
        if (throwable != null) {
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof WebApplicationException) {
                throw (WebApplicationException)throwable;
            }
            throw new IOException("Error while reading body", throwable);
        }
    }

    private static Response closingResponse(int status, String message) {
        return Response.status((int)status).entity((Object)message).header(HeaderNames.CONNECTION.toString(), (Object)HeaderValues.CLOSE).build();
    }

    public void cleanup() {
    }

    static class StringRequestBodyReader
    extends RequestBodyReader {
        private final Charset bodyCharset;
        private final CompositeByteBuf list = Unpooled.compositeBuffer();
        private volatile String result;

        public StringRequestBodyReader(long maxSize, Charset bodyCharset) {
            super(maxSize);
            this.bodyCharset = bodyCharset;
        }

        @Override
        public void onRequestBodyRead0(ByteBuf content, boolean last, DoneCallback callback) {
            try {
                if (content.readableBytes() > 0) {
                    this.list.addComponent(true, content.retain());
                }
                if (last) {
                    this.result = this.list.toString(this.bodyCharset);
                    this.list.release();
                }
                callback.onComplete(null);
            }
            catch (Exception e) {
                try {
                    callback.onComplete(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        void onCancelled(Throwable cause) {
            super.onCancelled(cause);
            this.list.release();
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.result = null;
        }

        public String body() {
            if (this.result == null) {
                throw new IllegalStateException("Can only read the body after the entire body is read and before the request is completed");
            }
            return this.result;
        }
    }

    static class MultipartFormReader
    extends RequestBodyReader
    implements FormRequestBodyReader {
        private static final Logger log = LoggerFactory.getLogger(MultipartFormReader.class);
        private final HttpPostMultipartRequestDecoder multipartRequestDecoder;
        private RequestParameters form;
        private final HashMap<String, List<UploadedFile>> uploads = new HashMap();

        @Override
        public RequestParameters params() {
            return this.form;
        }

        public MultipartFormReader(long maxSize, HttpRequest nettyRequest, Charset charset) {
            super(maxSize);
            DefaultHttpDataFactory factory = new DefaultHttpDataFactory(charset);
            this.multipartRequestDecoder = new HttpPostMultipartRequestDecoder((HttpDataFactory)factory, nettyRequest, charset);
        }

        @Override
        public void onRequestBodyRead0(ByteBuf content, boolean last, DoneCallback callback) {
            this.multipartRequestDecoder.offer((HttpContent)new DefaultHttpContent(content));
            if (last) {
                this.multipartRequestDecoder.offer((HttpContent)new DefaultLastHttpContent());
                List bodyHttpDatas = this.multipartRequestDecoder.getBodyHttpDatas();
                HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
                for (InterfaceHttpData bodyHttpData : bodyHttpDatas) {
                    if (bodyHttpData instanceof FileUpload) {
                        FileUpload fileUpload = (FileUpload)bodyHttpData;
                        if (fileUpload.length() == 0L && Mutils.nullOrEmpty(fileUpload.getFilename())) continue;
                        MuUploadedFile uploadedFile = new MuUploadedFile(fileUpload);
                        this.addFile(fileUpload.getName(), uploadedFile);
                        continue;
                    }
                    if (bodyHttpData instanceof Attribute) {
                        Attribute a = (Attribute)bodyHttpData;
                        try {
                            String name = a.getName();
                            List values = parameters.computeIfAbsent(name, k -> new LinkedList());
                            values.add(a.getValue());
                            continue;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException("Error reading form parameter", e);
                        }
                    }
                    log.warn("Unrecognised body part: " + bodyHttpData.getClass() + " from " + this + " - this may mean some of the request data is lost.");
                }
                this.form = new NettyRequestParameters(parameters);
            }
            try {
                callback.onComplete(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void cleanup() {
            super.cleanup();
            this.multipartRequestDecoder.destroy();
        }

        private void addFile(String name, UploadedFile file) {
            if (!this.uploads.containsKey(name)) {
                this.uploads.put(name, new ArrayList());
            }
            this.uploads.get(name).add(file);
        }

        @Override
        public List<UploadedFile> uploads(String name) {
            List<UploadedFile> list = this.uploads.get(name);
            return list == null ? Collections.emptyList() : list;
        }
    }

    static class UrlEncodedBodyReader
    extends RequestBodyReader
    implements FormRequestBodyReader {
        private final StringRequestBodyReader stringReader;
        private RequestParameters form;

        public UrlEncodedBodyReader(StringRequestBodyReader stringReader) {
            super(stringReader.maxSize);
            this.stringReader = stringReader;
        }

        @Override
        public List<UploadedFile> uploads(String name) {
            return Collections.emptyList();
        }

        @Override
        public RequestParameters params() {
            return this.form;
        }

        @Override
        public void onRequestBodyRead0(ByteBuf content, boolean last, DoneCallback callback) {
            this.stringReader.onRequestBodyRead(content, last, error -> {
                if (error == null && last) {
                    QueryStringDecoder decoder = new QueryStringDecoder(this.stringReader.body(), StandardCharsets.UTF_8, false, 1000000);
                    this.form = new NettyRequestParameters(decoder.parameters());
                }
                callback.onComplete(error);
            });
        }
    }

    static class DiscardingReader
    extends RequestBodyReader {
        DiscardingReader(long maxSize) {
            super(maxSize);
        }

        @Override
        public void onRequestBodyRead0(ByteBuf content, boolean last, DoneCallback callback) {
            try {
                callback.onComplete(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class ListenerAdapter
    extends RequestBodyReader {
        private final NettyRequestAdapter.AsyncHandleImpl asyncHandle;
        private final RequestBodyListener readListener;

        public ListenerAdapter(NettyRequestAdapter.AsyncHandleImpl asyncHandle, long maxSize, RequestBodyListener readListener) {
            super(maxSize);
            this.asyncHandle = asyncHandle;
            this.readListener = readListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRequestBodyRead0(ByteBuf content, boolean last, DoneCallback callback) {
            try {
                if (content.readableBytes() > 0) {
                    DoneCallback successCalled = !last ? callback : error -> {
                        if (error == null) {
                            this.readListener.onComplete();
                        } else {
                            this.readListener.onError(error);
                        }
                        callback.onComplete(error);
                    };
                    this.readListener.onDataReceived(content.nioBuffer(), successCalled);
                } else if (last) {
                    this.readListener.onComplete();
                    callback.onComplete(null);
                }
            }
            catch (Exception e) {
                try {
                    callback.onComplete(e);
                }
                catch (Exception exception) {
                }
                finally {
                    this.readListener.onError(e);
                }
            }
        }

        @Override
        void onCancelled(Throwable cause) {
            super.onCancelled(cause);
            this.readListener.onError(cause);
            this.asyncHandle.complete(cause);
        }
    }
}

