/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.DoneCallback;
import io.muserver.MuException;
import io.muserver.RequestBodyReader;
import io.netty.buffer.ByteBuf;
import jakarta.ws.rs.WebApplicationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class RequestBodyReaderInputStreamAdapter
extends RequestBodyReader {
    private boolean receivedLast = false;
    private boolean finished = false;
    private ByteBuf currentBuf;
    private DoneCallback currentCallback;
    private boolean userClosed = false;
    private final Object lock = new Object();
    private final InputStream stream = new InputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = RequestBodyReaderInputStreamAdapter.this.lock;
            synchronized (object) {
                if (RequestBodyReaderInputStreamAdapter.this.finished) {
                    return -1;
                }
                while (RequestBodyReaderInputStreamAdapter.this.currentBuf == null || RequestBodyReaderInputStreamAdapter.this.currentBuf.readableBytes() == 0 && !RequestBodyReaderInputStreamAdapter.this.receivedLast) {
                    RequestBodyReaderInputStreamAdapter.this.waitForData();
                }
                if (RequestBodyReaderInputStreamAdapter.this.currentBuf.readableBytes() == 0) {
                    RequestBodyReaderInputStreamAdapter.this.afterConsumed();
                    return -1;
                }
                byte b = RequestBodyReaderInputStreamAdapter.this.currentBuf.readByte();
                RequestBodyReaderInputStreamAdapter.this.afterConsumed();
                return b;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            Object object = RequestBodyReaderInputStreamAdapter.this.lock;
            synchronized (object) {
                if (RequestBodyReaderInputStreamAdapter.this.userClosed) {
                    throw new IOException("Cannot call read after the stream is closed");
                }
                if (RequestBodyReaderInputStreamAdapter.this.finished) {
                    return -1;
                }
                while (RequestBodyReaderInputStreamAdapter.this.currentBuf == null) {
                    RequestBodyReaderInputStreamAdapter.this.waitForData();
                }
                int actual = Math.min(len, RequestBodyReaderInputStreamAdapter.this.currentBuf.readableBytes());
                if (actual > 0) {
                    RequestBodyReaderInputStreamAdapter.this.currentBuf.readBytes(b, off, actual);
                }
                RequestBodyReaderInputStreamAdapter.this.afterConsumed();
                return actual;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            Object object = RequestBodyReaderInputStreamAdapter.this.lock;
            synchronized (object) {
                RequestBodyReaderInputStreamAdapter.this.waitForData();
                int toSkip = Math.min((int)n, RequestBodyReaderInputStreamAdapter.this.currentBuf.readableBytes());
                RequestBodyReaderInputStreamAdapter.this.currentBuf.skipBytes(toSkip);
                RequestBodyReaderInputStreamAdapter.this.afterConsumed();
                return toSkip;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() {
            Object object = RequestBodyReaderInputStreamAdapter.this.lock;
            synchronized (object) {
                return RequestBodyReaderInputStreamAdapter.this.currentBuf == null ? 0 : RequestBodyReaderInputStreamAdapter.this.currentBuf.readableBytes();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = RequestBodyReaderInputStreamAdapter.this.lock;
            synchronized (object) {
                if (!RequestBodyReaderInputStreamAdapter.this.userClosed) {
                    RequestBodyReaderInputStreamAdapter.this.userClosed = true;
                    if (RequestBodyReaderInputStreamAdapter.this.currentCallback != null) {
                        try {
                            RequestBodyReaderInputStreamAdapter.this.currentCallback.onComplete(null);
                        }
                        catch (Exception e2) {
                            throw new IOException("Exception raising error", e2);
                        }
                        RequestBodyReaderInputStreamAdapter.this.currentBuf = null;
                    }
                }
            }
        }
    };

    private void throwIfErrored() throws IOException {
        Throwable cur = this.currentError();
        if (cur instanceof WebApplicationException) {
            throw (WebApplicationException)cur;
        }
        if (cur != null) {
            throw new IOException("Error while reading request body", cur);
        }
    }

    @Override
    public void cleanup() {
        if (this.currentCallback != null) {
            try {
                this.currentCallback.onComplete(new MuException("Request did not complete"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentCallback = null;
        }
    }

    RequestBodyReaderInputStreamAdapter(long maxSize) {
        super(maxSize);
    }

    public InputStream inputStream() {
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onCancelled(Throwable cause) {
        super.onCancelled(cause);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequestBodyRead0(ByteBuf content, boolean last, DoneCallback callback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.userClosed) {
                try {
                    callback.onComplete(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            if (this.currentBuf != null) {
                throw new IllegalStateException("Got content before the previous was completed");
            }
            if (this.currentCallback != null) {
                throw new IllegalStateException("Got content before the previous callback was invoked");
            }
            this.currentBuf = content;
            this.currentCallback = callback;
            if (last) {
                this.receivedLast = true;
            }
            this.lock.notify();
        }
    }

    private void afterConsumed() throws IOException {
        if (this.currentBuf.readableBytes() == 0) {
            this.currentBuf = null;
            try {
                this.currentCallback.onComplete(null);
                this.currentCallback = null;
            }
            catch (Exception e) {
                throw new IOException("Error completing done callback", e);
            }
            finally {
                if (this.receivedLast) {
                    this.finished = true;
                }
            }
        }
    }

    private void waitForData() throws IOException {
        this.throwIfErrored();
        if (this.currentBuf != null) {
            return;
        }
        try {
            this.lock.wait();
            this.throwIfErrored();
        }
        catch (InterruptedException e) {
            DoneCallback cb = this.currentCallback;
            if (cb != null) {
                try {
                    cb.onComplete(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new InterruptedIOException("Timed out waiting for data");
        }
    }
}

