/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.SSLInfo;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SSLInfoImpl
implements SSLInfo {
    private static final Logger log = LoggerFactory.getLogger(SSLInfoImpl.class);
    private final String providerName;
    private final List<String> protocols;
    private final List<String> ciphers;
    private volatile List<X509Certificate> cachedCerts = null;
    private volatile URI httpsUri;

    SSLInfoImpl(String providerName, List<String> protocols, List<String> ciphers) {
        this.providerName = providerName;
        this.protocols = protocols;
        this.ciphers = ciphers;
    }

    @Override
    public List<String> ciphers() {
        return this.ciphers;
    }

    @Override
    public List<String> protocols() {
        return this.protocols;
    }

    @Override
    public String providerName() {
        return this.providerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<X509Certificate> certificates() {
        if (this.cachedCerts != null) {
            return this.cachedCerts;
        }
        HttpURLConnection conn = null;
        try {
            Certificate[] certs;
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            conn = (HttpsURLConnection)this.httpsUri.toURL().openConnection();
            ((HttpsURLConnection)conn).setSSLSocketFactory(ctx.getSocketFactory());
            ((HttpsURLConnection)conn).setHostnameVerifier((arg0, arg1) -> true);
            conn.connect();
            ArrayList<X509Certificate> results = new ArrayList<X509Certificate>();
            for (Certificate cert : certs = ((HttpsURLConnection)conn).getServerCertificates()) {
                if (!(cert instanceof X509Certificate)) continue;
                results.add((X509Certificate)cert);
            }
            this.cachedCerts = results;
            ArrayList<X509Certificate> arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            log.warn("Error finding SSL certificate info", (Throwable)e);
            List<X509Certificate> list = Collections.emptyList();
            return list;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public String toString() {
        return "SSLInfoImpl{providerName='" + this.providerName + '\'' + ", protocols=" + this.protocols + ", ciphers=" + this.ciphers + '}';
    }

    void setHttpsUri(URI httpsUri) {
        this.httpsUri = httpsUri;
    }
}

