/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuRequest;
import io.muserver.RateLimiterImpl;
import java.util.List;
import java.util.Set;

class ServerSettings {
    final long minimumGzipSize;
    final int maxHeadersSize;
    final long requestReadTimeoutMillis;
    final long maxRequestSize;
    final int maxUrlSize;
    final boolean gzipEnabled;
    final Set<String> mimeTypesToGzip;
    final List<RateLimiterImpl> rateLimiters;

    ServerSettings(long minimumGzipSize, int maxHeadersSize, long requestReadTimeoutMillis, long maxRequestSize, int maxUrlSize, boolean gzipEnabled, Set<String> mimeTypesToGzip, List<RateLimiterImpl> rateLimiters) {
        this.minimumGzipSize = minimumGzipSize;
        this.maxHeadersSize = maxHeadersSize;
        this.requestReadTimeoutMillis = requestReadTimeoutMillis;
        this.maxRequestSize = maxRequestSize;
        this.maxUrlSize = maxUrlSize;
        this.gzipEnabled = gzipEnabled;
        this.mimeTypesToGzip = mimeTypesToGzip;
        this.rateLimiters = rateLimiters;
    }

    boolean shouldCompress(String declaredLength, String contentType) {
        if (!this.gzipEnabled) {
            return false;
        }
        if (declaredLength != null && Long.parseLong(declaredLength) <= this.minimumGzipSize) {
            return false;
        }
        if (contentType == null) {
            return false;
        }
        int i = contentType.indexOf(";");
        if (i > -1) {
            contentType = contentType.substring(0, i);
        }
        return this.mimeTypesToGzip.contains(contentType.trim());
    }

    public boolean block(MuRequest request) {
        boolean allowed = true;
        if (this.rateLimiters != null) {
            for (RateLimiterImpl limiter : this.rateLimiters) {
                allowed &= limiter.record(request);
            }
        }
        return !allowed;
    }

    public String toString() {
        return "ServerSettings{minimumGzipSize=" + this.minimumGzipSize + ", maxHeadersSize=" + this.maxHeadersSize + ", requestReadTimeoutMillis=" + this.requestReadTimeoutMillis + ", maxRequestSize=" + this.maxRequestSize + ", maxUrlSize=" + this.maxUrlSize + ", gzipEnabled=" + this.gzipEnabled + ", rateLimiters=" + this.rateLimiters + '}';
    }
}

