/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;

class SniKeyManager
extends X509ExtendedKeyManager {
    private final X509ExtendedKeyManager keyManager;
    private final String defaultAlias;
    private final Map<String, String> sanToAliasMap;

    public SniKeyManager(X509ExtendedKeyManager keyManager, String defaultAlias, Map<String, String> sanToAliasMap) {
        this.keyManager = keyManager;
        this.defaultAlias = defaultAlias;
        this.sanToAliasMap = sanToAliasMap;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        throw new UnsupportedOperationException("Not a client");
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        throw new UnsupportedOperationException("Not a client");
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        throw new UnsupportedOperationException("Not a client");
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        throw new UnsupportedOperationException("SSLSocket not expected to be used");
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        String hostname;
        ExtendedSSLSession session = (ExtendedSSLSession)engine.getHandshakeSession();
        String sniHostname = null;
        for (SNIServerName name : session.getRequestedServerNames()) {
            if (name.getType() != 0) continue;
            sniHostname = ((SNIHostName)name).getAsciiName();
            break;
        }
        if ((hostname = (String)this.sanToAliasMap.getOrDefault(sniHostname, sniHostname)) != null && this.getCertificateChain(hostname) != null && this.getPrivateKey(hostname) != null) {
            return hostname;
        }
        return this.defaultAlias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }
}

