/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.SSLInfo;
import io.muserver.SSLInfoImpl;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SslContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;

class SslContextProvider {
    private final AtomicReference<SslContext> nettySslContext = new AtomicReference();
    private volatile SSLInfo sslInfo;

    SslContextProvider(SslContext context) {
        this.set(context);
    }

    public SslContext get() {
        return this.nettySslContext.get();
    }

    public void set(SslContext newValue) {
        String provider = newValue instanceof JdkSslContext ? "JDK" : (newValue instanceof OpenSslContext || newValue instanceof ReferenceCountedOpenSslContext ? "OpenSSL" : "unknown");
        SSLEngine engine = newValue.newEngine(ByteBufAllocator.DEFAULT);
        List<String> protocols = Arrays.asList(engine.getEnabledProtocols());
        List<String> ciphers = Arrays.asList(engine.getEnabledCipherSuites());
        this.sslInfo = new SSLInfoImpl(provider, protocols, ciphers);
        engine.closeOutbound();
        this.nettySslContext.set(newValue);
    }

    SSLInfo sslInfo() {
        return this.sslInfo;
    }
}

