/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.HeaderNames;
import io.muserver.HeaderValues;
import io.muserver.Http1Headers;
import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.MuWebSocket;
import io.muserver.MuWebSocketFactory;
import io.muserver.Mutils;
import io.muserver.NettyRequestAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;

public class WebSocketHandler
implements MuHandler {
    private final MuWebSocketFactory factory;
    private final String path;
    private final long idleReadTimeoutMills;
    private final long pingAfterWriteMillis;
    private final int maxFramePayloadLength;

    WebSocketHandler(MuWebSocketFactory factory, String path, long idleReadTimeoutMills, long pingAfterWriteMillis, int maxFramePayloadLength) {
        this.factory = factory;
        this.path = path;
        this.idleReadTimeoutMills = idleReadTimeoutMills;
        this.pingAfterWriteMillis = pingAfterWriteMillis;
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    @Override
    public boolean handle(MuRequest request, MuResponse response) throws Exception {
        boolean upgraded;
        if (request.method() != Method.GET) {
            return false;
        }
        if (Mutils.hasValue(this.path) && !this.path.equals(request.relativePath())) {
            return false;
        }
        if (!WebSocketHandler.isWebSocketUpgrade(request)) {
            return false;
        }
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders();
        Http1Headers responseHeaders = new Http1Headers((HttpHeaders)nettyHeaders);
        MuWebSocket muWebSocket = this.factory.create(request, responseHeaders);
        if (muWebSocket == null) {
            return false;
        }
        NettyRequestAdapter reqImpl = (NettyRequestAdapter)request;
        try {
            upgraded = reqImpl.websocketUpgrade(muWebSocket, (HttpHeaders)nettyHeaders, this.idleReadTimeoutMills, this.pingAfterWriteMillis, this.maxFramePayloadLength);
        }
        catch (UnsupportedOperationException e) {
            response.status(426);
            response.headers().set(HeaderNames.SEC_WEBSOCKET_VERSION, (Object)"13");
            return true;
        }
        return upgraded;
    }

    static boolean isWebSocketUpgrade(MuRequest request) {
        return request.headers().contains(HeaderNames.UPGRADE, HeaderValues.WEBSOCKET, true);
    }

    public String toString() {
        return "WebSocketHandler{path='" + this.path + '\'' + ", idleReadTimeoutMills=" + this.idleReadTimeoutMills + ", pingAfterWriteMillis=" + this.pingAfterWriteMillis + ", maxFramePayloadLength=" + this.maxFramePayloadLength + '}';
    }
}

