/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.AsyncHandle;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.handlers.ResourceProvider;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncFileProvider
implements ResourceProvider,
CompletionHandler<Integer, Object> {
    private static final Logger log = LoggerFactory.getLogger(AsyncFileProvider.class);
    private final Path localPath;
    private AsynchronousFileChannel channel;
    private long curPos = 0L;
    private ByteBuffer buf;
    private AsyncHandle handle;
    private long maxLen;
    private long bytesSent = 0L;

    AsyncFileProvider(Path baseDirectory, String relativePath) {
        if (relativePath.startsWith("/")) {
            relativePath = "." + relativePath;
        }
        this.localPath = baseDirectory.resolve(relativePath);
    }

    @Override
    public boolean exists() {
        return Files.exists(this.localPath, new LinkOption[0]);
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.localPath, new LinkOption[0]);
    }

    @Override
    public Long fileSize() {
        try {
            long size = Files.size(this.localPath);
            if (size == 0L && this.isDirectory()) {
                return null;
            }
            return size;
        }
        catch (IOException e) {
            log.error("Error finding file size: " + e.getMessage());
            return null;
        }
    }

    @Override
    public Date lastModified() {
        try {
            return new Date(Files.getLastModifiedTime(this.localPath, new LinkOption[0]).toMillis());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean skipIfPossible(long bytes) {
        this.curPos = bytes;
        return true;
    }

    @Override
    public void sendTo(MuRequest request, MuResponse response, boolean sendBody, long maxLen) throws IOException {
        if (sendBody) {
            this.maxLen = maxLen;
            this.handle = request.handleAsync();
            this.channel = AsynchronousFileChannel.open(this.localPath, StandardOpenOption.READ);
            this.buf = ByteBuffer.allocate(8192);
            this.channel.read(this.buf, this.curPos, this.handle, this);
        }
    }

    @Override
    public Stream<Path> listFiles() throws IOException {
        return Files.list(this.localPath);
    }

    @Override
    public void completed(Integer bytesRead, Object a) {
        this.buf.flip();
        if (bytesRead == -1) {
            this.handle.complete();
            this.closeChannelQuietly();
        } else {
            long remaining = Math.max(0L, this.maxLen - this.bytesSent);
            if (remaining < (long)this.buf.limit()) {
                this.buf.limit((int)remaining);
            }
            this.handle.write(this.buf, error -> {
                if (error == null) {
                    this.buf.clear();
                    this.curPos += (long)bytesRead.intValue();
                    this.bytesSent += (long)bytesRead.intValue();
                    this.channel.read(this.buf, this.curPos, null, this);
                } else {
                    this.closeChannelQuietly();
                    this.handle.complete(error);
                }
            });
        }
    }

    private void closeChannelQuietly() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            log.debug("Error while closing file channel " + this.localPath, (Throwable)e);
        }
    }

    @Override
    public void failed(Throwable exc, Object a) {
        log.info("File read failure for " + this.localPath, exc);
        this.handle.complete(exc);
    }
}

