/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BytesRange {
    final long from;
    final long to;
    final long total;

    private BytesRange(long from, long to, long total) {
        this.from = Math.max(0L, from);
        this.to = to;
        this.total = total;
        if (from > to || to >= total) {
            throw new IllegalArgumentException("The range " + from + " and " + to + " is invalid for length " + total);
        }
    }

    static List<BytesRange> parse(long totalBytes, String value) {
        if (value == null || value.trim().isEmpty() || !value.startsWith("bytes=")) {
            return Collections.emptyList();
        }
        String[] split = value.substring("bytes=".length()).split(",");
        ArrayList<BytesRange> ranges = new ArrayList<BytesRange>();
        for (String s : split) {
            String[] bits = s.split("-", 2);
            if (bits.length != 2) {
                throw new IllegalArgumentException("Invalid range");
            }
            long from = BytesRange.getRangeValue(bits[0]);
            long to = BytesRange.getRangeValue(bits[1]);
            if (from == -1L && to == -1L) {
                throw new IllegalArgumentException("Invalid range value: " + s);
            }
            if (from == -1L) {
                from = totalBytes - to;
                to = totalBytes - 1L;
            } else if (to == -1L) {
                to = totalBytes - 1L;
            }
            from = Math.max(0L, from);
            to = Math.min(to, totalBytes - 1L);
            ranges.add(new BytesRange(from, to, totalBytes));
        }
        return ranges;
    }

    private static long getRangeValue(String bit) {
        if ((bit = bit.trim()).isEmpty()) {
            return -1L;
        }
        try {
            return Long.parseLong(bit);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public String toString() {
        return "bytes " + this.from + "-" + this.to + "/" + this.total;
    }

    public long length() {
        return this.to - this.from + 1L;
    }
}

