/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.handlers;

import io.muserver.MuHandlerBuilder;
import io.muserver.handlers.HttpsRedirector;
import java.util.concurrent.TimeUnit;

public class HttpsRedirectorBuilder
implements MuHandlerBuilder<HttpsRedirector> {
    private int port = -1;
    private long expireTimeInSeconds = -1L;
    private boolean includeSubDomainsForHSTS = false;
    private boolean preload = false;

    @Override
    public HttpsRedirector build() {
        if (this.port < 1) {
            throw new IllegalArgumentException("The HTTPS port to redirect to should be a positive number");
        }
        return new HttpsRedirector(this.port, this.expireTimeInSeconds, this.includeSubDomainsForHSTS, this.preload);
    }

    public HttpsRedirectorBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public HttpsRedirectorBuilder withHSTSPreload(boolean preload) {
        this.preload = preload;
        return this;
    }

    public HttpsRedirectorBuilder withHSTSExpireTime(int expireTime, TimeUnit unit) {
        this.expireTimeInSeconds = unit.toSeconds(expireTime);
        return this;
    }

    public HttpsRedirectorBuilder includeSubDomains(boolean includeSubDomainsForHSTS) {
        this.includeSubDomainsForHSTS = includeSubDomainsForHSTS;
        return this;
    }

    public static HttpsRedirectorBuilder toHttpsPort(int port) {
        return new HttpsRedirectorBuilder().withPort(port);
    }
}

