/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.CallbackObject;
import io.muserver.openapi.ComponentsObject;
import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.HeaderObject;
import io.muserver.openapi.LinkObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.RequestBodyObject;
import io.muserver.openapi.ResponseObject;
import io.muserver.openapi.SchemaObject;
import io.muserver.openapi.SecuritySchemeObject;
import java.util.Map;

public class ComponentsObjectBuilder {
    Map<String, SchemaObject> schemas;
    private Map<String, ResponseObject> responses;
    private Map<String, ParameterObject> parameters;
    private Map<String, ExampleObject> examples;
    private Map<String, RequestBodyObject> requestBodies;
    private Map<String, HeaderObject> headers;
    private Map<String, SecuritySchemeObject> securitySchemes;
    private Map<String, LinkObject> links;
    private Map<String, CallbackObject> callbacks;

    public ComponentsObjectBuilder withSchemas(Map<String, SchemaObject> schemas) {
        this.schemas = schemas;
        return this;
    }

    public ComponentsObjectBuilder withResponses(Map<String, ResponseObject> responses) {
        this.responses = responses;
        return this;
    }

    public ComponentsObjectBuilder withParameters(Map<String, ParameterObject> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ComponentsObjectBuilder withExamples(Map<String, ExampleObject> examples) {
        this.examples = examples;
        return this;
    }

    public ComponentsObjectBuilder withRequestBodies(Map<String, RequestBodyObject> requestBodies) {
        this.requestBodies = requestBodies;
        return this;
    }

    public ComponentsObjectBuilder withHeaders(Map<String, HeaderObject> headers) {
        this.headers = headers;
        return this;
    }

    public ComponentsObjectBuilder withSecuritySchemes(Map<String, SecuritySchemeObject> securitySchemes) {
        this.securitySchemes = securitySchemes;
        return this;
    }

    public ComponentsObjectBuilder withLinks(Map<String, LinkObject> links) {
        this.links = links;
        return this;
    }

    public ComponentsObjectBuilder withCallbacks(Map<String, CallbackObject> callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    public ComponentsObject build() {
        return new ComponentsObject(OpenApiUtils.immutable(this.schemas), OpenApiUtils.immutable(this.responses), OpenApiUtils.immutable(this.parameters), OpenApiUtils.immutable(this.examples), OpenApiUtils.immutable(this.requestBodies), OpenApiUtils.immutable(this.headers), OpenApiUtils.immutable(this.securitySchemes), OpenApiUtils.immutable(this.links), OpenApiUtils.immutable(this.callbacks));
    }

    public static ComponentsObjectBuilder componentsObject() {
        return new ComponentsObjectBuilder();
    }

    public static ComponentsObjectBuilder componentsObject(ComponentsObject toCopy) {
        ComponentsObjectBuilder builder = ComponentsObjectBuilder.componentsObject();
        if (toCopy != null) {
            builder.withCallbacks(toCopy.callbacks()).withExamples(toCopy.examples()).withHeaders(toCopy.headers()).withLinks(toCopy.links()).withParameters(toCopy.parameters()).withRequestBodies(toCopy.requestBodies()).withResponses(toCopy.responses()).withSecuritySchemes(toCopy.securitySchemes()).withSchemas(toCopy.schemas());
        }
        return builder;
    }
}

