/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.EncodingObject;
import io.muserver.openapi.HeaderObject;
import io.muserver.openapi.OpenApiUtils;
import java.util.Map;

public class EncodingObjectBuilder {
    private String contentType;
    private Map<String, HeaderObject> headers;
    private String style;
    private Boolean explode;
    private Boolean allowReserved;

    public EncodingObjectBuilder withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public EncodingObjectBuilder withHeaders(Map<String, HeaderObject> headers) {
        this.headers = headers;
        return this;
    }

    public EncodingObjectBuilder withStyle(String style) {
        this.style = style;
        return this;
    }

    public EncodingObjectBuilder withExplode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public EncodingObjectBuilder withAllowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    public EncodingObject build() {
        return new EncodingObject(this.contentType, OpenApiUtils.immutable(this.headers), this.style, this.explode, this.allowReserved);
    }

    public static EncodingObjectBuilder encodingObject() {
        return new EncodingObjectBuilder();
    }
}

