/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.HeaderObject;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.SchemaObject;
import java.util.Map;

public class HeaderObjectBuilder {
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private String style;
    private Boolean explode;
    private SchemaObject schema;
    private Object example;
    private Map<String, ExampleObject> examples;
    private Map<String, MediaTypeObject> content;

    public HeaderObjectBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public HeaderObjectBuilder withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public HeaderObjectBuilder withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public HeaderObjectBuilder withStyle(String style) {
        this.style = style;
        return this;
    }

    public HeaderObjectBuilder withExplode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public HeaderObjectBuilder withSchema(SchemaObject schema) {
        this.schema = schema;
        return this;
    }

    public HeaderObjectBuilder withExample(Object example) {
        this.example = example;
        return this;
    }

    public HeaderObjectBuilder withExamples(Map<String, ExampleObject> examples) {
        this.examples = examples;
        return this;
    }

    public HeaderObjectBuilder withContent(Map<String, MediaTypeObject> content) {
        this.content = content;
        return this;
    }

    public HeaderObject build() {
        return new HeaderObject(this.description, this.required, this.deprecated, this.style, this.explode, this.schema, this.example, OpenApiUtils.immutable(this.examples), OpenApiUtils.immutable(this.content));
    }

    public static HeaderObjectBuilder headerObject() {
        return new HeaderObjectBuilder();
    }
}

