/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.LicenseObject;
import java.net.URI;

public class LicenseObjectBuilder {
    private String name;
    private URI url;

    public LicenseObjectBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public LicenseObjectBuilder withUrl(URI url) {
        this.url = url;
        return this;
    }

    public LicenseObject build() {
        return new LicenseObject(this.name, this.url);
    }

    public static LicenseObjectBuilder licenseObject() {
        return new LicenseObjectBuilder();
    }

    public static LicenseObject Apache2_0() {
        return LicenseObjectBuilder.licenseObject().withName("Apache 2.0").withUrl(URI.create("http://www.apache.org/licenses/LICENSE-2.0.html")).build();
    }

    public static LicenseObject MITLicense() {
        return LicenseObjectBuilder.licenseObject().withName("MIT License").withUrl(URI.create("https://opensource.org/licenses/mit-license.php")).build();
    }

    public static LicenseObject TheUnlicense() {
        return LicenseObjectBuilder.licenseObject().withName("The Unlicense").withUrl(URI.create("https://unlicense.org")).build();
    }
}

