/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.OAuthFlowObject;
import io.muserver.openapi.OpenApiUtils;
import java.net.URI;
import java.util.Map;

public class OAuthFlowObjectBuilder {
    private URI authorizationUrl;
    private URI tokenUrl;
    private URI refreshUrl;
    private Map<String, String> scopes;

    public OAuthFlowObjectBuilder withAuthorizationUrl(URI authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public OAuthFlowObjectBuilder withTokenUrl(URI tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public OAuthFlowObjectBuilder withRefreshUrl(URI refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    public OAuthFlowObjectBuilder withScopes(Map<String, String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public OAuthFlowObject build() {
        return new OAuthFlowObject(this.authorizationUrl, this.tokenUrl, this.refreshUrl, OpenApiUtils.immutable(this.scopes));
    }

    public static OAuthFlowObjectBuilder oAuthFlowObject() {
        return new OAuthFlowObjectBuilder();
    }
}

