/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.Mutils;
import io.muserver.openapi.ComponentsObject;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.InfoObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.PathsObject;
import io.muserver.openapi.SecurityRequirementObject;
import io.muserver.openapi.ServerObject;
import io.muserver.openapi.TagObject;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.stream.Collectors;

public class OpenAPIObject
implements JsonWriter {
    private final String openapi = "3.0.1";
    private final InfoObject info;
    private final List<ServerObject> servers;
    private final PathsObject paths;
    private final ComponentsObject components;
    private final List<SecurityRequirementObject> security;
    private final List<TagObject> tags;
    private final ExternalDocumentationObject externalDocs;

    OpenAPIObject(InfoObject info, List<ServerObject> servers, PathsObject paths, ComponentsObject components, List<SecurityRequirementObject> security, List<TagObject> tags, ExternalDocumentationObject externalDocs) {
        Mutils.notNull("info", info);
        Mutils.notNull("paths", paths);
        if (tags != null && tags.size() != tags.stream().map(t -> t.name()).collect(Collectors.toSet()).size()) {
            throw new IllegalArgumentException("Tags must have unique names");
        }
        this.info = info;
        this.servers = servers;
        this.paths = paths;
        this.components = components;
        this.security = security;
        this.tags = tags;
        this.externalDocs = externalDocs;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "openapi", "3.0.1", isFirst);
        isFirst = Jsonizer.append(writer, "info", this.info, isFirst);
        isFirst = Jsonizer.append(writer, "servers", this.servers, isFirst);
        isFirst = Jsonizer.append(writer, "paths", this.paths, isFirst);
        isFirst = Jsonizer.append(writer, "components", this.components, isFirst);
        isFirst = Jsonizer.append(writer, "security", this.security, isFirst);
        isFirst = Jsonizer.append(writer, "tags", this.tags, isFirst);
        isFirst = Jsonizer.append(writer, "externalDocs", this.externalDocs, isFirst);
        writer.write(125);
    }

    public String openApi() {
        return "3.0.1";
    }

    public InfoObject info() {
        return this.info;
    }

    public List<ServerObject> servers() {
        return this.servers;
    }

    public PathsObject paths() {
        return this.paths;
    }

    public ComponentsObject components() {
        return this.components;
    }

    public List<SecurityRequirementObject> security() {
        return this.security;
    }

    public List<TagObject> tags() {
        return this.tags;
    }

    public ExternalDocumentationObject externalDocs() {
        return this.externalDocs;
    }
}

