/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.ComponentsObject;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.InfoObject;
import io.muserver.openapi.InfoObjectBuilder;
import io.muserver.openapi.OpenAPIObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.PathsObject;
import io.muserver.openapi.SecurityRequirementObject;
import io.muserver.openapi.ServerObject;
import io.muserver.openapi.TagObject;
import java.util.List;

public class OpenAPIObjectBuilder {
    private InfoObject info;
    private List<ServerObject> servers;
    private PathsObject paths;
    private ComponentsObject components;
    private List<SecurityRequirementObject> security;
    private List<TagObject> tags;
    private ExternalDocumentationObject externalDocs;

    public OpenAPIObjectBuilder withInfo(InfoObject info) {
        this.info = info;
        return this;
    }

    public OpenAPIObjectBuilder withServers(List<ServerObject> servers) {
        this.servers = servers;
        return this;
    }

    public OpenAPIObjectBuilder withPaths(PathsObject paths) {
        this.paths = paths;
        return this;
    }

    public OpenAPIObjectBuilder withComponents(ComponentsObject components) {
        this.components = components;
        return this;
    }

    public OpenAPIObjectBuilder withSecurity(List<SecurityRequirementObject> security) {
        this.security = security;
        return this;
    }

    public OpenAPIObjectBuilder withTags(List<TagObject> tags) {
        this.tags = tags;
        return this;
    }

    public OpenAPIObjectBuilder withExternalDocs(ExternalDocumentationObject externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public OpenAPIObject build() {
        InfoObject infoToUse = this.info == null ? InfoObjectBuilder.infoObject().build() : this.info;
        return new OpenAPIObject(infoToUse, OpenApiUtils.immutable(this.servers), this.paths, this.components, OpenApiUtils.immutable(this.security), OpenApiUtils.immutable(this.tags), this.externalDocs);
    }

    public static OpenAPIObjectBuilder openAPIObject() {
        return new OpenAPIObjectBuilder();
    }
}

