/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.Mutils;
import io.muserver.openapi.CallbackObject;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.RequestBodyObject;
import io.muserver.openapi.ResponsesObject;
import io.muserver.openapi.SecurityRequirementObject;
import io.muserver.openapi.ServerObject;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OperationObject
implements JsonWriter {
    private final List<String> tags;
    private final String summary;
    private final String description;
    private final ExternalDocumentationObject externalDocs;
    private final String operationId;
    private final List<ParameterObject> parameters;
    private final RequestBodyObject requestBody;
    private final ResponsesObject responses;
    private final Map<String, CallbackObject> callbacks;
    private final Boolean deprecated;
    private final List<SecurityRequirementObject> security;
    private final List<ServerObject> servers;

    OperationObject(List<String> tags, String summary, String description, ExternalDocumentationObject externalDocs, String operationId, List<ParameterObject> parameters, RequestBodyObject requestBody, ResponsesObject responses, Map<String, CallbackObject> callbacks, Boolean deprecated, List<SecurityRequirementObject> security, List<ServerObject> servers) {
        Set nameIns;
        Mutils.notNull("responses", responses);
        if (parameters != null && (nameIns = parameters.stream().map(p -> p.name() + "\u0000" + p.in()).collect(Collectors.toSet())).size() != parameters.size()) {
            throw new IllegalArgumentException("Got duplicate parameter name and locations in " + parameters + " for operation with summary " + summary);
        }
        this.tags = tags;
        this.summary = summary;
        this.description = description;
        this.externalDocs = externalDocs;
        this.operationId = operationId;
        this.parameters = parameters;
        this.requestBody = requestBody;
        this.responses = responses;
        this.callbacks = callbacks;
        this.deprecated = deprecated;
        this.security = security;
        this.servers = servers;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "tags", this.tags, isFirst);
        isFirst = Jsonizer.append(writer, "summary", this.summary, isFirst);
        isFirst = Jsonizer.append(writer, "description", this.description, isFirst);
        isFirst = Jsonizer.append(writer, "externalDocs", this.externalDocs, isFirst);
        isFirst = Jsonizer.append(writer, "operationId", this.operationId, isFirst);
        isFirst = Jsonizer.append(writer, "parameters", this.parameters, isFirst);
        isFirst = Jsonizer.append(writer, "requestBody", this.requestBody, isFirst);
        isFirst = Jsonizer.append(writer, "responses", this.responses, isFirst);
        isFirst = Jsonizer.append(writer, "callbacks", this.callbacks, isFirst);
        isFirst = Jsonizer.append(writer, "deprecated", this.deprecated, isFirst);
        isFirst = Jsonizer.append(writer, "security", this.security, isFirst);
        isFirst = Jsonizer.append(writer, "servers", this.servers, isFirst);
        writer.write(125);
    }

    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated != false;
    }

    public List<String> tags() {
        return this.tags;
    }

    public String summary() {
        return this.summary;
    }

    public String description() {
        return this.description;
    }

    public ExternalDocumentationObject externalDocs() {
        return this.externalDocs;
    }

    public String operationId() {
        return this.operationId;
    }

    public List<ParameterObject> parameters() {
        return this.parameters;
    }

    public RequestBodyObject requestBody() {
        return this.requestBody;
    }

    public ResponsesObject responses() {
        return this.responses;
    }

    public Map<String, CallbackObject> callbacks() {
        return this.callbacks;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }

    public List<SecurityRequirementObject> security() {
        return this.security;
    }

    public List<ServerObject> servers() {
        return this.servers;
    }
}

