/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.Mutils;
import io.muserver.openapi.ExampleObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.SchemaObject;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ParameterObject
implements JsonWriter {
    private static final List<String> allowedIns = Arrays.asList("query", "header", "path", "cookie");
    private static final List<String> allowedStyles = Arrays.asList("matrix", "label", "form", "simple", "spaceDelimited", "pipeDelimited", "deepObject");
    private final String name;
    private final String in;
    private final String description;
    private final boolean required;
    private final Boolean deprecated;
    private final Boolean allowEmptyValue;
    private final String style;
    private final Boolean explode;
    private final Boolean allowReserved;
    private final SchemaObject schema;
    private final Object example;
    private final Map<String, ExampleObject> examples;
    private final Map<String, MediaTypeObject> content;

    ParameterObject(String name, String in, String description, Boolean required, Boolean deprecated, Boolean allowEmptyValue, String style, Boolean explode, Boolean allowReserved, SchemaObject schema, Object example, Map<String, ExampleObject> examples, Map<String, MediaTypeObject> content) {
        Mutils.notNull("name", name);
        Mutils.notNull("in", in);
        if (!allowedIns.contains(in)) {
            throw new IllegalArgumentException("'in' must be one of " + allowedIns + " but was " + in);
        }
        if (style != null && !allowedStyles.contains(style)) {
            throw new IllegalArgumentException("'style' must be one of " + allowedStyles + " but was " + style);
        }
        if (content != null && content.size() != 1) {
            throw new IllegalArgumentException("'content', when specified, must have a single value only, but was " + content);
        }
        if (example != null && examples != null) {
            throw new IllegalArgumentException("Only one of 'example' and 'examples' can be supplied");
        }
        if ("path".equals(in) && !required.booleanValue()) {
            throw new IllegalArgumentException("'required' must be true for " + name + " because in is '" + in + "'");
        }
        if (schema == null && content == null) {
            throw new IllegalArgumentException("Either a schema or a content value must be specified");
        }
        this.name = name;
        this.in = in;
        this.description = description;
        this.required = required;
        this.deprecated = deprecated;
        this.allowEmptyValue = allowEmptyValue;
        this.style = style;
        this.explode = explode;
        this.allowReserved = allowReserved;
        this.schema = schema;
        this.example = example;
        this.examples = examples;
        this.content = content;
    }

    public static List<String> allowedIns() {
        return allowedIns;
    }

    public static List<String> allowedStyles() {
        return allowedStyles;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "name", this.name, isFirst);
        isFirst = Jsonizer.append(writer, "in", this.in, isFirst);
        isFirst = Jsonizer.append(writer, "description", this.description, isFirst);
        isFirst = Jsonizer.append(writer, "required", this.required, isFirst);
        isFirst = Jsonizer.append(writer, "deprecated", this.deprecated, isFirst);
        isFirst = Jsonizer.append(writer, "allowEmptyValue", this.allowEmptyValue, isFirst);
        isFirst = Jsonizer.append(writer, "style", this.style, isFirst);
        isFirst = Jsonizer.append(writer, "explode", this.explode, isFirst);
        isFirst = Jsonizer.append(writer, "allowReserved", this.allowReserved, isFirst);
        isFirst = Jsonizer.append(writer, "schema", this.schema, isFirst);
        isFirst = Jsonizer.append(writer, "example", this.example, isFirst);
        isFirst = Jsonizer.append(writer, "examples", this.examples, isFirst);
        isFirst = Jsonizer.append(writer, "content", this.content, isFirst);
        writer.write(125);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.writeJson(writer);
        }
        catch (IOException e) {
            return "Error from " + this.getClass() + " - " + e;
        }
        return ((Object)writer).toString();
    }

    public String name() {
        return this.name;
    }

    public String in() {
        return this.in;
    }

    public String description() {
        return this.description;
    }

    public boolean required() {
        return this.required;
    }

    public boolean deprecated() {
        return ParameterObject.actualValue(this.deprecated, false);
    }

    public boolean allowEmptyValue() {
        return ParameterObject.actualValue(this.allowEmptyValue, false);
    }

    public String style() {
        return this.style;
    }

    public boolean explode() {
        return ParameterObject.actualValue(this.explode, this.style == null || "form".equals(this.style));
    }

    public boolean allowReserved() {
        return ParameterObject.actualValue(this.allowReserved, false);
    }

    public SchemaObject schema() {
        return this.schema;
    }

    public Object example() {
        return this.example;
    }

    public Map<String, ExampleObject> examples() {
        return this.examples;
    }

    public Map<String, MediaTypeObject> content() {
        return this.content;
    }

    static boolean actualValue(Boolean value, boolean defaultValue) {
        return value == null ? defaultValue : value;
    }
}

