/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.openapi.DiscriminatorObject;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.JsonWriter;
import io.muserver.openapi.Jsonizer;
import io.muserver.openapi.SchemaObjectBuilder;
import io.muserver.openapi.XmlObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SchemaObject
implements JsonWriter {
    private final String title;
    private final Double multipleOf;
    private final Double maximum;
    private final Boolean exclusiveMaximum;
    private final Double minimum;
    private final Boolean exclusiveMinimum;
    private final Integer maxLength;
    private final Integer minLength;
    private final Pattern pattern;
    private final Integer maxItems;
    private final Integer minItems;
    private final Boolean uniqueItems;
    private final Integer maxProperties;
    private final Integer minProperties;
    private final List<String> required;
    private final List<Object> enumValue;
    private final String type;
    private final List<SchemaObject> allOf;
    private final List<SchemaObject> oneOf;
    private final List<SchemaObject> anyOf;
    private final List<SchemaObject> not;
    private final SchemaObject items;
    private final Map<String, SchemaObject> properties;
    private final Object additionalProperties;
    private final String description;
    private final String format;
    private final Object defaultValue;
    private final Boolean nullable;
    private final DiscriminatorObject discriminator;
    private final Boolean readOnly;
    private final Boolean writeOnly;
    private final XmlObject xml;
    private final ExternalDocumentationObject externalDocs;
    private final Object example;
    private final Boolean deprecated;

    SchemaObject(String title, Double multipleOf, Double maximum, Boolean exclusiveMaximum, Double minimum, Boolean exclusiveMinimum, Integer maxLength, Integer minLength, Pattern pattern, Integer maxItems, Integer minItems, Boolean uniqueItems, Integer maxProperties, Integer minProperties, List<String> required, List<Object> enumValue, String type, List<SchemaObject> allOf, List<SchemaObject> oneOf, List<SchemaObject> anyOf, List<SchemaObject> not, SchemaObject items, Map<String, SchemaObject> properties, Object additionalProperties, String description, String format, Object defaultValue, Boolean nullable, DiscriminatorObject discriminator, Boolean readOnly, Boolean writeOnly, XmlObject xml, ExternalDocumentationObject externalDocs, Object example, Boolean deprecated) {
        if (readOnly != null && readOnly.booleanValue() && writeOnly != null && writeOnly.booleanValue()) {
            throw new IllegalArgumentException("A schema cannot be both read only and write only");
        }
        if ("array".equals(type) && items == null) {
            throw new IllegalArgumentException("'items' cannot be null when type is 'array'");
        }
        if (defaultValue != null && type != null) {
            Class<?> defaultClass = defaultValue.getClass();
            switch (type) {
                case "number": {
                    if (Number.class.isAssignableFrom(defaultClass)) break;
                    throw new IllegalArgumentException("The default value must be a number but was " + defaultClass);
                }
                case "boolean": {
                    if (Boolean.class.isAssignableFrom(defaultClass)) break;
                    throw new IllegalArgumentException("The default value must be a boolean but was " + defaultClass);
                }
                case "array": {
                    if (Collection.class.isAssignableFrom(defaultClass) || defaultClass.isArray()) break;
                    throw new IllegalArgumentException("The default value must be a boolean but was " + defaultClass);
                }
            }
        }
        this.title = title;
        this.multipleOf = multipleOf;
        this.maximum = maximum;
        this.exclusiveMaximum = exclusiveMaximum;
        this.minimum = minimum;
        this.exclusiveMinimum = exclusiveMinimum;
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.pattern = pattern;
        this.maxItems = maxItems;
        this.minItems = minItems;
        this.uniqueItems = uniqueItems;
        this.maxProperties = maxProperties;
        this.minProperties = minProperties;
        this.required = required;
        this.enumValue = enumValue;
        this.type = type;
        this.allOf = allOf;
        this.oneOf = oneOf;
        this.anyOf = anyOf;
        this.not = not;
        this.items = items;
        this.properties = properties;
        this.additionalProperties = additionalProperties;
        this.description = description;
        this.format = format;
        this.defaultValue = defaultValue;
        this.nullable = nullable;
        this.discriminator = discriminator;
        this.readOnly = readOnly;
        this.writeOnly = writeOnly;
        this.xml = xml;
        this.externalDocs = externalDocs;
        this.example = example;
        this.deprecated = deprecated;
    }

    @Override
    public void writeJson(Writer writer) throws IOException {
        writer.append('{');
        boolean isFirst = true;
        isFirst = Jsonizer.append(writer, "title", this.title, isFirst);
        isFirst = Jsonizer.append(writer, "multipleOf", this.multipleOf, isFirst);
        isFirst = Jsonizer.append(writer, "maximum", this.maximum, isFirst);
        isFirst = Jsonizer.append(writer, "exclusiveMaximum", this.exclusiveMaximum, isFirst);
        isFirst = Jsonizer.append(writer, "minimum", this.minimum, isFirst);
        isFirst = Jsonizer.append(writer, "exclusiveMinimum", this.exclusiveMinimum, isFirst);
        isFirst = Jsonizer.append(writer, "maxLength", this.maxLength, isFirst);
        isFirst = Jsonizer.append(writer, "minLength", this.minLength, isFirst);
        isFirst = Jsonizer.append(writer, "pattern", this.pattern, isFirst);
        isFirst = Jsonizer.append(writer, "maxItems", this.maxItems, isFirst);
        isFirst = Jsonizer.append(writer, "minItems", this.minItems, isFirst);
        isFirst = Jsonizer.append(writer, "uniqueItems", this.uniqueItems, isFirst);
        isFirst = Jsonizer.append(writer, "maxProperties", this.maxProperties, isFirst);
        isFirst = Jsonizer.append(writer, "minProperties", this.minProperties, isFirst);
        isFirst = Jsonizer.append(writer, "required", this.required, isFirst);
        if (this.enumValue != null) {
            ArrayList<String> enums = new ArrayList<String>();
            if (this.nullable != null && this.nullable.booleanValue()) {
                enums.add(null);
            }
            for (Object o : this.enumValue) {
                enums.add(((Enum)o).name());
            }
            isFirst = Jsonizer.append(writer, "enum", enums, isFirst);
        }
        isFirst = Jsonizer.append(writer, "type", this.type, isFirst);
        isFirst = Jsonizer.append(writer, "allOf", this.allOf, isFirst);
        isFirst = Jsonizer.append(writer, "oneOf", this.oneOf, isFirst);
        isFirst = Jsonizer.append(writer, "anyOf", this.anyOf, isFirst);
        isFirst = Jsonizer.append(writer, "not", this.not, isFirst);
        isFirst = Jsonizer.append(writer, "items", this.items, isFirst);
        isFirst = Jsonizer.append(writer, "properties", this.properties, isFirst);
        isFirst = Jsonizer.append(writer, "additionalProperties", this.additionalProperties, isFirst);
        isFirst = Jsonizer.append(writer, "description", this.description, isFirst);
        isFirst = Jsonizer.append(writer, "format", this.format, isFirst);
        isFirst = Jsonizer.append(writer, "default", this.defaultValue, isFirst);
        isFirst = Jsonizer.append(writer, "nullable", this.nullable, isFirst);
        isFirst = Jsonizer.append(writer, "discriminator", this.discriminator, isFirst);
        isFirst = Jsonizer.append(writer, "readOnly", this.readOnly, isFirst);
        isFirst = Jsonizer.append(writer, "writeOnly", this.writeOnly, isFirst);
        isFirst = Jsonizer.append(writer, "xml", this.xml, isFirst);
        isFirst = Jsonizer.append(writer, "externalDocs", this.externalDocs, isFirst);
        isFirst = Jsonizer.append(writer, "example", this.example, isFirst);
        isFirst = Jsonizer.append(writer, "deprecated", this.deprecated, isFirst);
        writer.append('}');
    }

    public String toString() {
        return "SchemaObject{title='" + this.title + '\'' + ", multipleOf=" + this.multipleOf + ", maximum=" + this.maximum + ", exclusiveMaximum=" + this.exclusiveMaximum + ", minimum=" + this.minimum + ", exclusiveMinimum=" + this.exclusiveMinimum + ", maxLength=" + this.maxLength + ", minLength=" + this.minLength + ", pattern=" + this.pattern + ", maxItems=" + this.maxItems + ", minItems=" + this.minItems + ", uniqueItems=" + this.uniqueItems + ", maxProperties=" + this.maxProperties + ", minProperties=" + this.minProperties + ", required=" + this.required + ", enumValue=" + this.enumValue + ", type='" + this.type + '\'' + ", allOf=" + this.allOf + ", oneOf=" + this.oneOf + ", anyOf=" + this.anyOf + ", not=" + this.not + ", items=" + this.items + ", properties=" + this.properties + ", additionalProperties=" + this.additionalProperties + ", description='" + this.description + '\'' + ", format='" + this.format + '\'' + ", defaultValue=" + this.defaultValue + ", nullable=" + this.nullable + ", discriminator=" + this.discriminator + ", readOnly=" + this.readOnly + ", writeOnly=" + this.writeOnly + ", xml=" + this.xml + ", externalDocs=" + this.externalDocs + ", example=" + this.example + ", deprecated=" + this.deprecated + '}';
    }

    public SchemaObjectBuilder toBuilder() {
        return new SchemaObjectBuilder().withTitle(this.title).withMultipleOf(this.multipleOf).withMaximum(this.maximum).withExclusiveMaximum(this.exclusiveMaximum).withMinimum(this.minimum).withExclusiveMinimum(this.exclusiveMinimum).withMaxLength(this.maxLength).withMinLength(this.minLength).withPattern(this.pattern).withMaxItems(this.maxItems).withMinItems(this.minItems).withUniqueItems(this.uniqueItems).withMaxProperties(this.maxProperties).withMinProperties(this.minProperties).withRequired(this.required).withEnumValue(this.enumValue).withType(this.type).withAllOf(this.allOf).withOneOf(this.oneOf).withAnyOf(this.anyOf).withNot(this.not).withItems(this.items).withProperties(this.properties).withAdditionalProperties(this.additionalProperties).withDescription(this.description).withFormat(this.format).withDefaultValue(this.defaultValue).withNullable(this.nullable).withDiscriminator(this.discriminator).withReadOnly(this.readOnly).withWriteOnly(this.writeOnly).withXml(this.xml).withExternalDocs(this.externalDocs).withExample(this.example).withDeprecated(this.deprecated);
    }

    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated != false;
    }

    public String title() {
        return this.title;
    }

    public Double multipleOf() {
        return this.multipleOf;
    }

    public Double maximum() {
        return this.maximum;
    }

    public Boolean exclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Boolean exclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Integer maxLength() {
        return this.maxLength;
    }

    public Integer minLength() {
        return this.minLength;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Integer minItems() {
        return this.minItems;
    }

    public Boolean uniqueItems() {
        return this.uniqueItems;
    }

    public Integer maxProperties() {
        return this.maxProperties;
    }

    public Integer minProperties() {
        return this.minProperties;
    }

    public List<String> required() {
        return this.required;
    }

    public List<Object> enumValue() {
        return this.enumValue;
    }

    public String type() {
        return this.type;
    }

    public List<SchemaObject> allOf() {
        return this.allOf;
    }

    public List<SchemaObject> oneOf() {
        return this.oneOf;
    }

    public List<SchemaObject> anyOf() {
        return this.anyOf;
    }

    public List<SchemaObject> not() {
        return this.not;
    }

    public SchemaObject items() {
        return this.items;
    }

    public Map<String, SchemaObject> properties() {
        return this.properties;
    }

    public Object additionalProperties() {
        return this.additionalProperties;
    }

    public String description() {
        return this.description;
    }

    public String format() {
        return this.format;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public Boolean nullable() {
        return this.nullable;
    }

    public DiscriminatorObject discriminator() {
        return this.discriminator;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public Boolean writeOnly() {
        return this.writeOnly;
    }

    public XmlObject xml() {
        return this.xml;
    }

    public ExternalDocumentationObject externalDocs() {
        return this.externalDocs;
    }

    public Object example() {
        return this.example;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }
}

