/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.openapi;

import io.muserver.UploadedFile;
import io.muserver.openapi.DiscriminatorObject;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.OpenApiUtils;
import io.muserver.openapi.SchemaObject;
import io.muserver.openapi.XmlObject;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;

public class SchemaObjectBuilder {
    private String title;
    private Double multipleOf;
    private Double maximum;
    private Boolean exclusiveMaximum;
    private Double minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private Pattern pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Integer maxProperties;
    private Integer minProperties;
    private List<String> required;
    private List<Object> enumValue;
    private String type;
    private List<SchemaObject> allOf;
    private List<SchemaObject> oneOf;
    private List<SchemaObject> anyOf;
    private List<SchemaObject> not;
    private SchemaObject items;
    private Map<String, SchemaObject> properties;
    private Object additionalProperties;
    private String description;
    private String format;
    private Object defaultValue;
    private Boolean nullable;
    private DiscriminatorObject discriminator;
    private Boolean readOnly;
    private Boolean writeOnly;
    private XmlObject xml;
    private ExternalDocumentationObject externalDocs;
    private Object example;
    private Boolean deprecated;

    public String title() {
        return this.title;
    }

    public Double multipleOf() {
        return this.multipleOf;
    }

    public Double maximum() {
        return this.maximum;
    }

    public Boolean exclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Boolean exclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public Integer maxLength() {
        return this.maxLength;
    }

    public Integer minLength() {
        return this.minLength;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Integer minItems() {
        return this.minItems;
    }

    public Boolean uniqueItems() {
        return this.uniqueItems;
    }

    public Integer maxProperties() {
        return this.maxProperties;
    }

    public Integer minProperties() {
        return this.minProperties;
    }

    public List<String> required() {
        return this.required;
    }

    public List<Object> enumValue() {
        return this.enumValue;
    }

    public String type() {
        return this.type;
    }

    public List<SchemaObject> allOf() {
        return this.allOf;
    }

    public List<SchemaObject> oneOf() {
        return this.oneOf;
    }

    public List<SchemaObject> anyOf() {
        return this.anyOf;
    }

    public List<SchemaObject> not() {
        return this.not;
    }

    public SchemaObject items() {
        return this.items;
    }

    public Map<String, SchemaObject> properties() {
        return this.properties;
    }

    public Object additionalProperties() {
        return this.additionalProperties;
    }

    public String description() {
        return this.description;
    }

    public String format() {
        return this.format;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public Boolean nullable() {
        return this.nullable;
    }

    public DiscriminatorObject discriminator() {
        return this.discriminator;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public Boolean writeOnly() {
        return this.writeOnly;
    }

    public XmlObject xml() {
        return this.xml;
    }

    public ExternalDocumentationObject externalDocs() {
        return this.externalDocs;
    }

    public Object example() {
        return this.example;
    }

    public Boolean deprecated() {
        return this.deprecated;
    }

    public SchemaObjectBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public SchemaObjectBuilder withMultipleOf(Double multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public SchemaObjectBuilder withMaximum(Double maximum) {
        this.maximum = maximum;
        return this;
    }

    public SchemaObjectBuilder withExclusiveMaximum(Boolean exclusiveMaximum) {
        this.exclusiveMaximum = exclusiveMaximum;
        return this;
    }

    public SchemaObjectBuilder withMinimum(Double minimum) {
        this.minimum = minimum;
        return this;
    }

    public SchemaObjectBuilder withExclusiveMinimum(Boolean exclusiveMinimum) {
        this.exclusiveMinimum = exclusiveMinimum;
        return this;
    }

    public SchemaObjectBuilder withMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public SchemaObjectBuilder withMinLength(Integer minLength) {
        this.minLength = minLength;
        return this;
    }

    public SchemaObjectBuilder withPattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public SchemaObjectBuilder withMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public SchemaObjectBuilder withMinItems(Integer minItems) {
        this.minItems = minItems;
        return this;
    }

    public SchemaObjectBuilder withUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public SchemaObjectBuilder withMaxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public SchemaObjectBuilder withMinProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public SchemaObjectBuilder withRequired(List<String> required) {
        this.required = required;
        return this;
    }

    public SchemaObjectBuilder withEnumValue(List<Object> enumValue) {
        this.enumValue = enumValue;
        return this;
    }

    public SchemaObjectBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public SchemaObjectBuilder withAllOf(List<SchemaObject> allOf) {
        this.allOf = allOf;
        return this;
    }

    public SchemaObjectBuilder withOneOf(List<SchemaObject> oneOf) {
        this.oneOf = oneOf;
        return this;
    }

    public SchemaObjectBuilder withAnyOf(List<SchemaObject> anyOf) {
        this.anyOf = anyOf;
        return this;
    }

    public SchemaObjectBuilder withNot(List<SchemaObject> not) {
        this.not = not;
        return this;
    }

    public SchemaObjectBuilder withItems(SchemaObject items) {
        this.items = items;
        return this;
    }

    public SchemaObjectBuilder withProperties(Map<String, SchemaObject> properties) {
        this.properties = properties;
        return this;
    }

    public SchemaObjectBuilder withAdditionalProperties(Object additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public SchemaObjectBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public SchemaObjectBuilder withFormat(String format) {
        this.format = format;
        return this;
    }

    public SchemaObjectBuilder withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public SchemaObjectBuilder withNullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public SchemaObjectBuilder withDiscriminator(DiscriminatorObject discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public SchemaObjectBuilder withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public SchemaObjectBuilder withWriteOnly(Boolean writeOnly) {
        this.writeOnly = writeOnly;
        return this;
    }

    public SchemaObjectBuilder withXml(XmlObject xml) {
        this.xml = xml;
        return this;
    }

    public SchemaObjectBuilder withExternalDocs(ExternalDocumentationObject externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public SchemaObjectBuilder withExample(Object example) {
        this.example = example;
        return this;
    }

    public SchemaObjectBuilder withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public SchemaObject build() {
        return new SchemaObject(this.title, this.multipleOf, this.maximum, this.exclusiveMaximum, this.minimum, this.exclusiveMinimum, this.maxLength, this.minLength, this.pattern, this.maxItems, this.minItems, this.uniqueItems, this.maxProperties, this.minProperties, OpenApiUtils.immutable(this.required), OpenApiUtils.immutable(this.enumValue), this.type, OpenApiUtils.immutable(this.allOf), OpenApiUtils.immutable(this.oneOf), OpenApiUtils.immutable(this.anyOf), OpenApiUtils.immutable(this.not), this.items, OpenApiUtils.immutable(this.properties), this.additionalProperties, this.description, this.format, this.defaultValue, this.nullable, this.discriminator, this.readOnly, this.writeOnly, this.xml, this.externalDocs, this.example, this.deprecated);
    }

    public static SchemaObjectBuilder schemaObject() {
        return new SchemaObjectBuilder();
    }

    public static SchemaObjectBuilder schemaObjectFrom(Class<?> from) {
        return SchemaObjectBuilder.schemaObjectFrom(from, null, false);
    }

    public static SchemaObjectBuilder schemaObjectFrom(Class<?> from, Type parameterizedType, boolean required) {
        Objects.requireNonNull(from, "from");
        if (from.equals(Void.TYPE) || from.equals(Void.class)) {
            return SchemaObjectBuilder.schemaObject();
        }
        parameterizedType = SchemaObjectBuilder.getUpperBound(parameterizedType);
        String jsonType = SchemaObjectBuilder.jsonType(from);
        SchemaObjectBuilder schemaObjectBuilder = SchemaObjectBuilder.schemaObject().withType(jsonType).withFormat(SchemaObjectBuilder.jsonFormat(from)).withExample(SchemaObjectBuilder.example(from)).withNullable(!from.isPrimitive() && !required ? Boolean.valueOf(true) : null).withItems(SchemaObjectBuilder.itemsFor(from, parameterizedType, "array".equals(jsonType)));
        if (from.equals(UUID.class)) {
            schemaObjectBuilder.withPattern(Pattern.compile("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]"));
        } else if (from.isEnum()) {
            ?[] enumConstants = from.getEnumConstants();
            schemaObjectBuilder.withEnumValue(Arrays.asList(enumConstants));
        }
        return schemaObjectBuilder;
    }

    private static Object example(Class<?> clazz) {
        if (clazz.equals(UUID.class)) {
            return UUID.randomUUID();
        }
        if (Temporal.class.isAssignableFrom(clazz)) {
            try {
                return clazz.getDeclaredMethod("now", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Type getUpperBound(Type parameterizedType) {
        if (parameterizedType instanceof WildcardType && ((WildcardType)parameterizedType).getUpperBounds().length > 0) {
            parameterizedType = ((WildcardType)parameterizedType).getUpperBounds()[0];
        }
        return parameterizedType;
    }

    private static SchemaObject itemsFor(Class<?> from, Type parameterizedType, boolean isJsonArray) {
        Class<?> componentType = from.getComponentType();
        if (componentType == null) {
            if (isJsonArray) {
                Type argType;
                Type[] actualTypeArguments;
                SchemaObjectBuilder schemaObjectBuilder = SchemaObjectBuilder.schemaObject().withType("object");
                if (parameterizedType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)parameterizedType).getActualTypeArguments()).length == 1 && (argType = SchemaObjectBuilder.getUpperBound(actualTypeArguments[0])) instanceof Class) {
                    Class argClass = (Class)argType;
                    schemaObjectBuilder = SchemaObjectBuilder.schemaObjectFrom(argClass, null, true);
                }
                return schemaObjectBuilder.build();
            }
            return null;
        }
        return SchemaObjectBuilder.schemaObjectFrom(componentType).build();
    }

    private static String jsonType(Class<?> type) {
        if (CharSequence.class.isAssignableFrom(type) || type.equals(Byte.TYPE) || type.equals(Byte.class) || type.isAssignableFrom(Date.class) || Temporal.class.isAssignableFrom(type) || SchemaObjectBuilder.isBinaryClass(type) || type.isAssignableFrom(UUID.class) || type.isEnum()) {
            return "string";
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return "boolean";
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Long.TYPE) || type.equals(Long.class)) {
            return "integer";
        }
        if (Number.class.isAssignableFrom(type) || type.equals(Float.TYPE) || type.equals(Double.TYPE)) {
            return "number";
        }
        if (Collection.class.isAssignableFrom(type) || type.isArray()) {
            return "array";
        }
        return "object";
    }

    private static String jsonFormat(Class<?> type) {
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return "int32";
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return "int64";
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return "float";
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return "double";
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return "byte";
        }
        if (type.equals(Date.class) || type.equals(Instant.class)) {
            return "date-time";
        }
        if (type.equals(LocalDate.class)) {
            return "date";
        }
        if (SchemaObjectBuilder.isBinaryClass(type)) {
            return "binary";
        }
        if (type.equals(UUID.class)) {
            return "uuid";
        }
        return null;
    }

    private static boolean isBinaryClass(Class<?> type) {
        return UploadedFile.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || type.isArray() && type.getComponentType().equals(Byte.TYPE);
    }

    public String toString() {
        return "SchemaObjectBuilder{title='" + this.title + '\'' + ", multipleOf=" + this.multipleOf + ", maximum=" + this.maximum + ", exclusiveMaximum=" + this.exclusiveMaximum + ", minimum=" + this.minimum + ", exclusiveMinimum=" + this.exclusiveMinimum + ", maxLength=" + this.maxLength + ", minLength=" + this.minLength + ", pattern=" + this.pattern + ", maxItems=" + this.maxItems + ", minItems=" + this.minItems + ", uniqueItems=" + this.uniqueItems + ", maxProperties=" + this.maxProperties + ", minProperties=" + this.minProperties + ", required=" + this.required + ", enumValue=" + this.enumValue + ", type='" + this.type + '\'' + ", allOf=" + this.allOf + ", oneOf=" + this.oneOf + ", anyOf=" + this.anyOf + ", not=" + this.not + ", items=" + this.items + ", properties=" + this.properties + ", additionalProperties=" + this.additionalProperties + ", description='" + this.description + '\'' + ", format='" + this.format + '\'' + ", defaultValue=" + this.defaultValue + ", nullable=" + this.nullable + ", discriminator=" + this.discriminator + ", readOnly=" + this.readOnly + ", writeOnly=" + this.writeOnly + ", xml=" + this.xml + ", externalDocs=" + this.externalDocs + ", example=" + this.example + ", deprecated=" + this.deprecated + '}';
    }
}

