/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Method;
import io.muserver.Mutils;
import io.muserver.handlers.CORSHandlerBuilder;
import io.muserver.rest.CORSConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class CORSConfigBuilder {
    private boolean allowCredentials = false;
    private Collection<String> allowedOrigins = Collections.emptySet();
    private List<Pattern> allowedOriginRegex = new ArrayList<Pattern>();
    private Collection<String> exposedHeaders = Collections.emptySet();
    private Collection<String> allowedHeaders = Collections.emptySet();
    private long maxAge = -1L;

    public CORSConfigBuilder withAllOriginsAllowed() {
        return this.withAllowedOrigins((Collection<String>)null);
    }

    public CORSConfigBuilder withAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
        return this;
    }

    public CORSConfigBuilder withAllowedOrigins(Collection<String> allowedOrigins) {
        if (allowedOrigins != null) {
            for (String allowedOrigin : allowedOrigins) {
                if (!allowedOrigin.startsWith("http://") && !allowedOrigin.startsWith("https://")) {
                    throw new IllegalArgumentException(allowedOrigin + " is invalid: origins much have an http:// or https:// prefix");
                }
                if (allowedOrigin.lastIndexOf(47) <= 8) continue;
                throw new IllegalArgumentException(allowedOrigin + " is invalid: origins should not have any paths. Example origin: https://example.org");
            }
        }
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CORSConfigBuilder withAllowedOrigins(String ... allowedOrigins) {
        return this.withAllowedOrigins(Arrays.asList(allowedOrigins));
    }

    public CORSConfigBuilder withAllowedOriginRegex(Pattern allowedOriginRegex) {
        if (allowedOriginRegex != null) {
            this.allowedOriginRegex.add(allowedOriginRegex);
        }
        return this;
    }

    public CORSConfigBuilder withAllowedOriginRegex(String allowedOriginRegex) {
        if (allowedOriginRegex == null) {
            return this;
        }
        return this.withAllowedOriginRegex(Pattern.compile(allowedOriginRegex));
    }

    public CORSConfigBuilder withLocalhostAllowed() {
        return this.withAllowedOriginRegex(Pattern.compile("https?://localhost(:[0-9]+)?"));
    }

    public CORSConfigBuilder withExposedHeaders(String ... headerNames) {
        Mutils.notNull("headerNames", headerNames);
        return this.withExposedHeaders(Arrays.asList(headerNames));
    }

    public CORSConfigBuilder withExposedHeaders(Collection<String> headerNames) {
        Mutils.notNull("headerNames", headerNames);
        this.exposedHeaders = headerNames;
        return this;
    }

    public CORSConfigBuilder withAllowedHeaders(String ... headerNames) {
        Mutils.notNull("headerNames", headerNames);
        return this.withAllowedHeaders(Arrays.asList(headerNames));
    }

    public CORSConfigBuilder withAllowedHeaders(Collection<String> headerNames) {
        Mutils.notNull("headerNames", headerNames);
        this.allowedHeaders = headerNames;
        return this;
    }

    public CORSConfigBuilder withMaxAge(long seconds) {
        this.maxAge = seconds;
        return this;
    }

    public static CORSConfigBuilder corsConfig() {
        return new CORSConfigBuilder().withMaxAge(600L);
    }

    public static CORSConfigBuilder disabled() {
        return new CORSConfigBuilder();
    }

    public CORSHandlerBuilder toHandler(Method ... allowedMethods) {
        return CORSHandlerBuilder.corsHandler().withCORSConfig(this).withAllowedMethods(allowedMethods);
    }

    public CORSConfig build() {
        return new CORSConfig(this.allowCredentials, this.allowedOrigins, this.allowedOriginRegex, this.allowedHeaders, this.exposedHeaders, this.maxAge);
    }
}

