/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.ParameterizedHeader;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CacheControlHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<CacheControl> {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");

    CacheControlHeaderDelegate() {
    }

    public CacheControl fromString(String value) {
        ParameterizedHeader dir = ParameterizedHeader.fromString(value);
        CacheControl cc = new CacheControl();
        HashMap<String, String> pams = new HashMap<String, String>(dir.parameters());
        cc.setProxyRevalidate(pams.containsKey("proxy-revalidate"));
        pams.remove("proxy-revalidate");
        cc.setMustRevalidate(pams.containsKey("must-revalidate"));
        pams.remove("must-revalidate");
        cc.setNoTransform(pams.containsKey("no-transform"));
        pams.remove("no-transform");
        cc.setNoStore(pams.containsKey("no-store"));
        pams.remove("no-store");
        cc.setNoCache(pams.containsKey("no-cache"));
        pams.remove("no-cache");
        cc.setPrivate(pams.containsKey("private"));
        pams.remove("private");
        if (pams.containsKey("max-age")) {
            cc.setMaxAge(Integer.parseInt((String)pams.get("max-age")));
            pams.remove("max-age");
        }
        if (pams.containsKey("s-maxage")) {
            cc.setSMaxAge(Integer.parseInt((String)pams.get("s-maxage")));
            pams.remove("s-maxage");
        }
        cc.getCacheExtension().putAll(pams);
        return cc;
    }

    public String toString(CacheControl value) {
        StringBuilder sb = new StringBuilder();
        if (value.isPrivate()) {
            CacheControlHeaderDelegate.appendQuotedWithSeparator(sb, "private", CacheControlHeaderDelegate.buildListValue(value.getPrivateFields()));
        }
        if (value.isNoCache()) {
            CacheControlHeaderDelegate.appendQuotedWithSeparator(sb, "no-cache", CacheControlHeaderDelegate.buildListValue(value.getNoCacheFields()));
        }
        if (value.isNoStore()) {
            CacheControlHeaderDelegate.appendWithSeparator(sb, "no-store");
        }
        if (value.isNoTransform()) {
            CacheControlHeaderDelegate.appendWithSeparator(sb, "no-transform");
        }
        if (value.isMustRevalidate()) {
            CacheControlHeaderDelegate.appendWithSeparator(sb, "must-revalidate");
        }
        if (value.isProxyRevalidate()) {
            CacheControlHeaderDelegate.appendWithSeparator(sb, "proxy-revalidate");
        }
        if (value.getMaxAge() != -1) {
            CacheControlHeaderDelegate.appendWithSeparator(sb, "max-age", value.getMaxAge());
        }
        if (value.getSMaxAge() != -1) {
            CacheControlHeaderDelegate.appendWithSeparator(sb, "s-maxage", value.getSMaxAge());
        }
        for (Map.Entry e : value.getCacheExtension().entrySet()) {
            String val = (String)e.getValue();
            CacheControlHeaderDelegate.appendWithSeparator(sb, (String)e.getKey(), CacheControlHeaderDelegate.quoteIfWhitespace(val));
        }
        return sb.toString();
    }

    static String buildListValue(List<String> values) {
        StringBuilder b = new StringBuilder();
        for (String value : values) {
            CacheControlHeaderDelegate.appendWithSeparator(b, value);
        }
        return b.toString();
    }

    static void appendWithSeparator(StringBuilder b, String field) {
        if (b.length() > 0) {
            b.append(", ");
        }
        b.append(field);
    }

    static void appendQuotedWithSeparator(StringBuilder b, String field, String value) {
        CacheControlHeaderDelegate.appendWithSeparator(b, field);
        if (value != null && !value.isEmpty()) {
            b.append("=\"");
            b.append(value);
            b.append("\"");
        }
    }

    static void appendWithSeparator(StringBuilder b, String field, int value) {
        CacheControlHeaderDelegate.appendWithSeparator(b, field);
        b.append("=");
        b.append(value);
    }

    static void appendWithSeparator(StringBuilder b, String field, String value) {
        CacheControlHeaderDelegate.appendWithSeparator(b, field);
        if (value != null && !value.isEmpty()) {
            b.append("=");
            b.append(value);
        }
    }

    static String quoteIfWhitespace(String value) {
        if (value == null) {
            return null;
        }
        Matcher m = WHITESPACE.matcher(value);
        if (m.find()) {
            return "\"" + value + "\"";
        }
        return value;
    }
}

