/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.MuException;
import io.muserver.openapi.SchemaObjectBuilder;
import io.muserver.rest.SchemaObjectCustomizer;
import io.muserver.rest.SchemaObjectCustomizerContext;
import java.util.Collections;
import java.util.List;

class CompositeSchemaObjectCustomizer
implements SchemaObjectCustomizer {
    private final List<SchemaObjectCustomizer> customizers;

    CompositeSchemaObjectCustomizer(List<SchemaObjectCustomizer> customizers) {
        this.customizers = Collections.unmodifiableList(customizers);
    }

    @Override
    public SchemaObjectBuilder customize(SchemaObjectBuilder builder, SchemaObjectCustomizerContext context) {
        for (SchemaObjectCustomizer customizer : this.customizers) {
            try {
                builder = customizer.customize(builder, context);
            }
            catch (Exception e) {
                throw new MuException("Error while customizing " + context + " with " + customizer, e);
            }
            if (builder != null) continue;
            throw new IllegalStateException(customizer + " returned null. A schema object builder must always be returned");
        }
        return builder;
    }
}

