/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.openapi.ExternalDocumentationObject;
import io.muserver.openapi.ExternalDocumentationObjectBuilder;
import io.muserver.openapi.TagObject;
import io.muserver.openapi.TagObjectBuilder;
import io.muserver.rest.Description;
import java.lang.reflect.AnnotatedElement;
import java.net.URI;
import java.net.URISyntaxException;

class DescriptionData {
    final String summary;
    final String description;
    final ExternalDocumentationObject externalDocumentation;
    final String example;

    DescriptionData(String summary, String description, ExternalDocumentationObject externalDocumentation, String example) {
        this.summary = summary;
        this.description = description;
        this.externalDocumentation = externalDocumentation;
        this.example = example;
    }

    static DescriptionData fromAnnotation(AnnotatedElement source, String defaultSummary) {
        Description description = source.getAnnotation(Description.class);
        if (description == null) {
            return new DescriptionData(defaultSummary, null, null, null);
        }
        ExternalDocumentationObject externalDocumentation = null;
        if (!description.documentationUrl().isEmpty()) {
            try {
                URI uri = new URI(description.documentationUrl());
                externalDocumentation = ExternalDocumentationObjectBuilder.externalDocumentationObject().withUrl(uri).build();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("The class " + source + " specifies a documentationUrl however it is not a value URL. The value is " + description.documentationUrl());
            }
        }
        String summary = description.value();
        String desc = description.details();
        String example = description.example();
        return new DescriptionData(summary.isEmpty() ? defaultSummary : summary, desc.isEmpty() ? null : desc, externalDocumentation, example.isEmpty() ? null : example);
    }

    TagObject toTag() {
        return TagObjectBuilder.tagObject().withName(this.summary).withDescription(this.description).withExternalDocs(this.externalDocumentation).build();
    }

    public String summaryAndDescription() {
        String s = Mutils.coalesce(this.summary, "");
        if (!Mutils.nullOrEmpty(this.description)) {
            s = s + " - " + this.description;
        }
        return s;
    }
}

