/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import java.lang.annotation.Annotation;

class JaxClassLocator {
    JaxClassLocator() {
    }

    static Class<?> getClassWithJaxRSAnnotations(Class<?> start) {
        Class<?> clazz;
        for (clazz = start; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!JaxClassLocator.hasAtLeastOneJaxRSAnnotation(clazz.getDeclaredAnnotations())) continue;
            return clazz;
        }
        for (clazz = start; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                if (!JaxClassLocator.hasAtLeastOneJaxRSAnnotation(interfaceClass.getDeclaredAnnotations())) continue;
                return interfaceClass;
            }
        }
        return null;
    }

    static boolean hasAtLeastOneJaxRSAnnotation(Annotation[] annotations) {
        boolean hasAJaxAnnotation = false;
        for (Annotation annotation : annotations) {
            String packageName = annotation.annotationType().getPackage().getName();
            if (!packageName.equals("jakarta.ws.rs") && !packageName.startsWith("jakarta.ws.rs.")) continue;
            hasAJaxAnnotation = true;
        }
        return hasAJaxAnnotation;
    }
}

