/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.HeaderNames;
import io.muserver.MediaTypeParser;
import io.muserver.Method;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.rest.EntityProviders;
import io.muserver.rest.JaxRSResponse;
import io.muserver.rest.JaxRsHttpHeadersAdapter;
import io.muserver.rest.MuVariantListBuilder;
import io.muserver.rest.RequestMatcher;
import io.muserver.rest.ResourceClass;
import io.muserver.rest.RestHandler;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class JaxRSRequest
implements Request,
ContainerRequestContext,
ReaderInterceptorContext {
    final MuRequest muRequest;
    private final MuResponse muResponse;
    private InputStream inputStream;
    private final String relativePath;
    private final JaxRsHttpHeadersAdapter jaxHeaders;
    private UriInfo uriInfo;
    private RequestMatcher.MatchedMethod matchedMethod;
    private SecurityContext securityContext;
    private Annotation[] annotations = JaxRSResponse.Builder.EMPTY_ANNOTATIONS;
    private Class<?> type;
    private Type genericType;
    private int nextReader;
    private final List<ReaderInterceptor> readerInterceptors;
    private final EntityProviders entityProviders;
    private String httpMethod;

    JaxRSRequest(MuRequest muRequest, MuResponse muResponse, InputStream inputStream, String relativePath, SecurityContext securityContext, List<ReaderInterceptor> readerInterceptors, EntityProviders entityProviders) {
        this.muRequest = muRequest;
        this.httpMethod = muRequest.method().name();
        this.muResponse = muResponse;
        this.inputStream = inputStream;
        this.relativePath = relativePath;
        this.securityContext = securityContext;
        this.readerInterceptors = readerInterceptors;
        this.entityProviders = entityProviders;
        String basePath = muRequest.contextPath();
        if (!basePath.endsWith("/")) {
            basePath = basePath + "/";
        }
        this.uriInfo = RestHandler.createUriInfo(relativePath, null, muRequest.uri().resolve(basePath), muRequest.uri());
        this.jaxHeaders = new JaxRsHttpHeadersAdapter(muRequest.headers(), muRequest.cookies());
    }

    boolean methodHasAnnotations(List<Class<? extends Annotation>> toCheck) {
        if (this.matchedMethod == null) {
            return false;
        }
        return this.matchedMethod.resourceMethod.hasAll(toCheck);
    }

    public Object getProperty(String name) {
        if ("io.muserver.MU_REQUEST".equals(name)) {
            return this.muRequest;
        }
        if ("io.muserver.RESOURCE_INFO".equals(name)) {
            Class<?> resourceInstanceClass = this.matchedMethod == null ? null : this.matchedMethod.matchedClass.resourceClass.resourceInstance.getClass();
            java.lang.reflect.Method resourceInstanceMethod = this.matchedMethod == null ? null : this.matchedMethod.resourceMethod.methodHandle;
            return new MuResourceInfo(resourceInstanceClass, resourceInstanceMethod);
        }
        return this.muRequest.attribute(name);
    }

    public Collection<String> getPropertyNames() {
        HashSet<String> copy = new HashSet<String>(this.muRequest.attributes().keySet());
        copy.add("io.muserver.MU_REQUEST");
        copy.add("io.muserver.RESOURCE_INFO");
        return Collections.unmodifiableSet(copy);
    }

    public void setProperty(String name, Object object) {
        this.muRequest.attribute(name, object);
    }

    public void removeProperty(String name) {
        this.muRequest.attribute(name, null);
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            throw new NullPointerException("The 'annotations' parameter must not be null");
        }
        this.annotations = annotations;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setRequestUri(URI requestUri) {
        this.setRequestUri(this.uriInfo.getBaseUri(), requestUri);
    }

    public void setRequestUri(URI baseUri, URI requestUri) {
        if (this.matchedMethod != null) {
            throw new IllegalStateException("This method is only valid for @PreMatching filters");
        }
        URI absoluteUri = baseUri.resolve(requestUri);
        this.uriInfo = RestHandler.createUriInfo(baseUri.relativize(requestUri).getRawPath(), null, baseUri, absoluteUri);
    }

    public Request getRequest() {
        return this;
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public Variant selectVariant(List<Variant> variants) {
        for (Variant variant : variants) {
            if (variant.getMediaType() != null && !this.muResponse.headers().contains(HeaderNames.VARY, HeaderNames.ACCEPT, true)) {
                this.muResponse.headers().add(HeaderNames.VARY, (Object)HeaderNames.ACCEPT);
            }
            if (variant.getEncoding() != null && !this.muResponse.headers().contains(HeaderNames.VARY, HeaderNames.ACCEPT_ENCODING, true)) {
                this.muResponse.headers().add(HeaderNames.VARY, (Object)HeaderNames.ACCEPT_ENCODING);
            }
            if (variant.getLanguage() == null || this.muResponse.headers().contains(HeaderNames.VARY, HeaderNames.ACCEPT_LANGUAGE, true)) continue;
            this.muResponse.headers().add(HeaderNames.VARY, (Object)HeaderNames.ACCEPT_LANGUAGE);
        }
        String acceptLang = this.jaxHeaders.getHeaderString("accept-language");
        List<Locale.LanguageRange> ranges = Locale.LanguageRange.parse(acceptLang == null ? "*" : acceptLang);
        return MuVariantListBuilder.selectVariant(variants, ranges, this.getAcceptableMediaTypes(), this.muRequest.headers().acceptEncoding());
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        if (eTag == null) {
            throw new IllegalArgumentException("eTag is null");
        }
        Response.ResponseBuilder ifMatchBuilder = this.evaluateIfMatch(eTag);
        return ifMatchBuilder != null ? ifMatchBuilder : this.evaluateIfNoneMatch(eTag);
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        boolean anyMatch = false;
        List<String> ifMatches = this.muRequest.headers().getAll(HeaderNames.IF_MATCH);
        if (ifMatches.isEmpty()) {
            return null;
        }
        if (eTag.isWeak()) {
            return Response.status((int)412).entity((Object)new ClientErrorException("Precondition failed: if-match failed due to weak eTag", 412));
        }
        for (String suppliedEtag : ifMatches) {
            EntityTag supplied = EntityTag.valueOf((String)suppliedEtag);
            if (!supplied.equals((Object)eTag)) continue;
            anyMatch = true;
            break;
        }
        if (anyMatch) {
            return null;
        }
        return Response.status((int)412).entity((Object)new ClientErrorException("Precondition failed: if-match", 412));
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag) {
        List<String> ifNoneMatchTags = this.muRequest.headers().getAll(HeaderNames.IF_NONE_MATCH);
        boolean getOrHead = this.isGetOrHead();
        if (!getOrHead && eTag.isWeak()) {
            return Response.status((int)412).entity((Object)new ClientErrorException("Precondition failed: if-match failed due to weak eTag", 412));
        }
        boolean noneMatch = true;
        for (String suppliedEtag : ifNoneMatchTags) {
            EntityTag supplied = EntityTag.valueOf((String)suppliedEtag);
            if (!supplied.equals((Object)eTag) && (!getOrHead || !supplied.getValue().equals(eTag.getValue()))) continue;
            noneMatch = false;
            break;
        }
        if (noneMatch) {
            return null;
        }
        return getOrHead ? Response.status((int)304).tag(eTag) : Response.status((int)412).entity((Object)new ClientErrorException("Precondition failed: if-match", 412));
    }

    private boolean isGetOrHead() {
        return this.muRequest.method() == Method.GET || this.muRequest.method() == Method.HEAD;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        if (lastModified == null) {
            throw new IllegalArgumentException("lastModified is null");
        }
        Response.ResponseBuilder ifUnmodifiedSince = this.evaluateIfUnmodifiedSince(lastModified);
        return ifUnmodifiedSince != null ? ifUnmodifiedSince : this.evaluateIfModifiedSince(lastModified);
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(Date lastModified) {
        long lastModifiedSeconds = lastModified.getTime() / 1000L;
        Long ifModifiedMillis = this.muRequest.headers().getTimeMillis(HeaderNames.IF_MODIFIED_SINCE);
        if (ifModifiedMillis == null || lastModifiedSeconds > ifModifiedMillis / 1000L) {
            return null;
        }
        return this.isGetOrHead() ? Response.notModified() : null;
    }

    private Response.ResponseBuilder evaluateIfUnmodifiedSince(Date lastModified) {
        long lastModifiedSeconds = lastModified.getTime() / 1000L;
        Long ifUnmodifiedSince = this.muRequest.headers().getTimeMillis(HeaderNames.IF_UNMODIFIED_SINCE);
        if (ifUnmodifiedSince == null || lastModifiedSeconds <= ifUnmodifiedSince / 1000L) {
            return null;
        }
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new ClientErrorException("Failed precondition: if-unmodified-since", 412));
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        if (lastModified == null) {
            throw new IllegalArgumentException("lastModified is null");
        }
        if (eTag == null) {
            throw new IllegalArgumentException("eTag is null");
        }
        Response.ResponseBuilder builder = this.evaluateIfMatch(eTag);
        if (builder != null) {
            return builder;
        }
        builder = this.evaluateIfUnmodifiedSince(lastModified);
        if (builder != null) {
            return builder;
        }
        builder = this.evaluateIfNoneMatch(eTag);
        if (builder != null) {
            return builder;
        }
        builder = this.evaluateIfModifiedSince(lastModified);
        if (builder != null) {
            builder.tag(eTag);
        }
        return builder;
    }

    public Response.ResponseBuilder evaluatePreconditions() {
        return this.muRequest.headers().get(HeaderNames.IF_MATCH) == null ? null : Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new ClientErrorException("Precondition failed: if-match", 412));
    }

    Method getMuMethod() {
        return Method.valueOf(this.getMethod());
    }

    public void setMethod(String method) {
        if (this.matchedMethod != null) {
            throw new IllegalStateException("This method is only valid for @PreMatching filters");
        }
        Mutils.notNull("method", method);
        String upper = method.toUpperCase();
        this.httpMethod = Method.valueOf(upper).name();
    }

    Object executeInterceptors() throws IOException {
        this.nextReader = 0;
        return this.proceed();
    }

    public Object proceed() throws IOException, WebApplicationException {
        MediaType requestBodyMediaType;
        if (this.nextReader < this.readerInterceptors.size()) {
            ++this.nextReader;
            ReaderInterceptor nextInterceptor = this.readerInterceptors.get(this.nextReader - 1);
            List<Class<? extends Annotation>> filterBindings = ResourceClass.getNameBindingAnnotations(nextInterceptor.getClass());
            if (this.methodHasAnnotations(filterBindings)) {
                return nextInterceptor.aroundReadFrom((ReaderInterceptorContext)this);
            }
        }
        if ((requestBodyMediaType = this.getMediaType()) == null) {
            requestBodyMediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        Class<?> type = this.getType();
        Type genericType = this.getGenericType();
        Annotation[] annotations = this.getAnnotations();
        MessageBodyReader<?> messageBodyReader = this.entityProviders.selectReader(type, genericType, annotations, requestBodyMediaType);
        try {
            return messageBodyReader.readFrom(type, genericType, annotations, requestBodyMediaType, this.getHeaders(), this.getInputStream());
        }
        catch (NoContentException nce) {
            throw new BadRequestException("No request body was sent", (Throwable)nce);
        }
    }

    public InputStream getInputStream() {
        return this.getEntityStream();
    }

    public void setInputStream(InputStream is) {
        this.setEntityStream(is);
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.jaxHeaders.getMutableRequestHeaders();
    }

    public String getHeaderString(String name) {
        return this.jaxHeaders.getHeaderString(name);
    }

    public Date getDate() {
        return this.jaxHeaders.getDate();
    }

    public Locale getLanguage() {
        return this.jaxHeaders.getLanguage();
    }

    public int getLength() {
        return this.jaxHeaders.getLength();
    }

    public MediaType getMediaType() {
        return this.jaxHeaders.getMediaType();
    }

    public void setMediaType(MediaType mediaType) {
        if (mediaType == null) {
            this.jaxHeaders.getMutableRequestHeaders().remove((Object)"content-type");
        } else {
            this.jaxHeaders.getMutableRequestHeaders().putSingle((Object)"content-type", (Object)MediaTypeParser.toString(mediaType));
        }
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.jaxHeaders.getAcceptableMediaTypes();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.jaxHeaders.getAcceptableLanguages();
    }

    public Map<String, Cookie> getCookies() {
        return this.jaxHeaders.getCookies();
    }

    public boolean hasEntity() {
        return this.muRequest.headers().hasBody();
    }

    public InputStream getEntityStream() {
        return this.inputStream;
    }

    public void setEntityStream(InputStream input) {
        this.inputStream = input;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext context) {
        this.securityContext = context;
    }

    public void abortWith(Response response) {
        throw new FilterAbortedException(response);
    }

    void setMatchedMethod(RequestMatcher.MatchedMethod matchedMethod) {
        this.matchedMethod = matchedMethod;
        this.uriInfo = RestHandler.createUriInfo(this.relativePath, matchedMethod, this.uriInfo.getBaseUri(), this.uriInfo.getRequestUri());
    }

    public String toString() {
        return this.getMethod() + " " + this.uriInfo;
    }

    String relativePath() {
        return this.getUriInfo().getPath(false);
    }

    private static class MuResourceInfo
    implements ResourceInfo {
        private final Class<?> clazz;
        private final java.lang.reflect.Method method;

        private MuResourceInfo(Class<?> clazz, java.lang.reflect.Method method) {
            this.clazz = clazz;
            this.method = method;
        }

        public java.lang.reflect.Method getResourceMethod() {
            return this.method;
        }

        public Class<?> getResourceClass() {
            return this.clazz;
        }
    }

    static class FilterAbortedException
    extends WebApplicationException {
        public FilterAbortedException(Response response) {
            super(response);
        }
    }
}

