/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.MediaTypeParser;
import io.muserver.MuException;
import io.muserver.Mutils;
import io.muserver.rest.EntityProviders;
import io.muserver.rest.JaxRSRequest;
import io.muserver.rest.LowercasedMultivaluedHashMap;
import io.muserver.rest.MuRuntimeDelegate;
import io.muserver.rest.NotImplementedException;
import io.muserver.rest.ObjWithType;
import io.muserver.rest.ResourceClass;
import io.netty.handler.codec.http.HttpHeaderNames;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.RuntimeDelegate;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class JaxRSResponse
extends Response
implements ContainerResponseContext,
WriterInterceptorContext {
    private final MultivaluedMap<String, Object> headers;
    private Response.StatusType status;
    private ObjWithType objWithType;
    private final NewCookie[] cookies;
    private final List<Link> links;
    private Annotation[] annotations;
    private OutputStream outputStream;
    private JaxRSRequest requestContext;
    private List<WriterInterceptor> writerInterceptors;
    private int nextWriter = 0;
    private boolean isClosed = false;
    private ByteArrayInputStream inputStreamBuffer;

    JaxRSResponse(Response.StatusType status, MultivaluedMap<String, Object> headers, ObjWithType entity, NewCookie[] cookies, List<Link> links, Annotation[] annotations) {
        this.status = status;
        this.headers = headers;
        this.objWithType = entity;
        this.cookies = cookies;
        this.links = links;
        this.annotations = annotations;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            throw new NullPointerException("The 'annotations' parameter must not be null");
        }
        this.annotations = annotations;
    }

    public Class<?> getType() {
        return this.objWithType.type;
    }

    public void setType(Class<?> type) {
        this.objWithType = new ObjWithType(type, this.objWithType.genericType, this.objWithType.response, this.objWithType.entity);
    }

    public Type getGenericType() {
        return this.objWithType.genericType;
    }

    public void setGenericType(Type genericType) {
        this.objWithType = new ObjWithType(this.objWithType.type, genericType, this.objWithType.response, this.objWithType.entity);
    }

    public int getStatus() {
        return this.status.getStatusCode();
    }

    public void setStatus(int code) {
        this.status = Response.Status.fromStatusCode((int)code);
    }

    public Response.StatusType getStatusInfo() {
        return this.status;
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.status = statusInfo;
    }

    public Object getEntity() {
        return this.objWithType.entity;
    }

    public Class<?> getEntityClass() {
        return this.getType();
    }

    public Type getEntityType() {
        return this.getGenericType();
    }

    public void setEntity(Object entity) {
        this.objWithType = ObjWithType.objType(entity);
        if (entity instanceof Response) {
            Response resp = (Response)entity;
            this.setStatusInfo(resp.getStatusInfo());
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.setEntity(entity);
        this.setAnnotations(annotations);
        this.setMediaType(mediaType);
    }

    public Annotation[] getEntityAnnotations() {
        return this.getAnnotations();
    }

    public OutputStream getEntityStream() {
        return this.outputStream;
    }

    public void setEntityStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public <T> T readEntity(Class<T> entityType) {
        return this.readEntity0(entityType, null, new Annotation[0]);
    }

    private <T> T readEntity0(Class<T> entityType, Type genericType, Annotation[] annotations) {
        if (this.inputStreamBuffer == null && !InputStream.class.isAssignableFrom(this.getEntity().getClass())) {
            throw new IllegalStateException("The entity is not an input stream, it is " + this.getEntity().getClass());
        }
        if (this.isClosed) {
            throw new IllegalStateException("Cannot read entity; the response is closed");
        }
        InputStream toRead = this.inputStreamBuffer != null ? this.inputStreamBuffer : (InputStream)this.getEntity();
        EntityProviders ep = new EntityProviders(EntityProviders.builtInReaders(), Collections.emptyList());
        MessageBodyReader<?> reader = ep.selectReader(entityType, genericType, annotations, this.getMediaType());
        if (reader == null) {
            throw new ProcessingException("Cannot read this entity type");
        }
        try {
            Object result = reader.readFrom(entityType, genericType, annotations, this.getMediaType(), this.getStringHeaders(), toRead);
            if (this.inputStreamBuffer != null) {
                this.inputStreamBuffer.reset();
            } else {
                toRead.close();
            }
            this.setEntity(result);
            return (T)result;
        }
        catch (IOException e) {
            throw new ProcessingException("Error while reading entity input stream", (Throwable)e);
        }
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return this.readEntity0(entityType.getRawType(), entityType.getType(), new Annotation[0]);
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return this.readEntity0(entityType, null, annotations);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return this.readEntity0(entityType.getRawType(), entityType.getType(), annotations);
    }

    public boolean hasEntity() {
        return this.objWithType.entity != null;
    }

    public boolean bufferEntity() {
        if (this.inputStreamBuffer != null) {
            return true;
        }
        Object entity = this.getEntity();
        if (entity instanceof InputStream) {
            try (InputStream in = (InputStream)entity;
                 ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Mutils.copy(in, baos, 8192);
                this.inputStreamBuffer = new ByteArrayInputStream(baos.toByteArray());
                this.setEntity(this.inputStreamBuffer);
            }
            catch (IOException e) {
                throw new ProcessingException("Could not buffer entity input stream", (Throwable)e);
            }
            return true;
        }
        return false;
    }

    public void close() {
        if (!this.isClosed) {
            Object entity;
            this.isClosed = true;
            if (this.inputStreamBuffer != null) {
                try {
                    this.inputStreamBuffer.close();
                }
                catch (IOException e) {
                    throw new ProcessingException("Error while closing entity input stream", (Throwable)e);
                }
                this.inputStreamBuffer = null;
            }
            if ((entity = this.getEntity()) instanceof InputStream) {
                try {
                    ((InputStream)entity).close();
                }
                catch (IOException e) {
                    throw new ProcessingException("Could not close input stream entity", (Throwable)e);
                }
            }
        }
    }

    public MediaType getMediaType() {
        String h = this.getHeaderString("content-type");
        return h == null ? null : MediaTypeParser.fromString(h);
    }

    public void setMediaType(MediaType mediaType) {
        if (mediaType == null) {
            this.headers.remove((Object)"content-type");
        } else {
            this.headers.putSingle((Object)"content-type", (Object)MediaTypeParser.toString(mediaType));
        }
    }

    public Locale getLanguage() {
        String h = this.getHeaderString(HeaderNames.CONTENT_LANGUAGE.toString());
        if (h == null) {
            return null;
        }
        return Locale.forLanguageTag(h);
    }

    public int getLength() {
        String l = this.getHeaderString(HeaderNames.CONTENT_LENGTH.toString());
        if (l == null) {
            return -1;
        }
        try {
            return Integer.parseInt(l);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public Set<String> getAllowedMethods() {
        String allow = this.getHeaderString(HeaderNames.ALLOW.toString());
        return allow == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(allow.split(",")));
    }

    public Map<String, NewCookie> getCookies() {
        return Stream.of(this.cookies).collect(Collectors.toMap(Cookie::getName, c -> c));
    }

    public EntityTag getEntityTag() {
        Object first = this.headers.getFirst((Object)HeaderNames.ETAG.toString());
        if (first == null || first instanceof EntityTag) {
            return (EntityTag)first;
        }
        return EntityTag.valueOf((String)first.toString());
    }

    public Date getDate() {
        return this.dateFromHeader("date");
    }

    private Date dateFromHeader(String name) {
        Object date = this.headers.getFirst((Object)name);
        if (date == null || date.getClass().isAssignableFrom(Date.class)) {
            return (Date)date;
        }
        return Mutils.fromHttpDate(date.toString());
    }

    public Date getLastModified() {
        return this.dateFromHeader("last-modified");
    }

    public URI getLocation() {
        String s = this.getHeaderString("location");
        return s == null ? null : URI.create(s);
    }

    public Set<Link> getLinks() {
        return new HashSet<Link>(this.links);
    }

    public boolean hasLink(String relation) {
        return this.links.stream().anyMatch(link -> link.getRels().contains(relation));
    }

    public Link getLink(String relation) {
        return this.links.stream().filter(link -> link.getRels().contains(relation)).findFirst().orElse(null);
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }

    public MultivaluedMap<String, Object> getMetadata() {
        return this.headers;
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        LowercasedMultivaluedHashMap map = new LowercasedMultivaluedHashMap();
        for (Map.Entry entry : this.headers.entrySet()) {
            map.put((String)entry.getKey(), ((List)entry.getValue()).stream().map(JaxRSResponse::headerValueToString).collect(Collectors.toList()));
        }
        return map;
    }

    static MultivaluedMap<String, Object> muHeadersToJaxObj(Headers headers) {
        LowercasedMultivaluedHashMap map = new LowercasedMultivaluedHashMap();
        for (String name : headers.names()) {
            map.addAll(name, new Object[]{headers.getAll(name)});
        }
        return map;
    }

    public String getHeaderString(String name) {
        return JaxRSResponse.headerValueToString(this.headers.getFirst((Object)name));
    }

    private static String headerValueToString(Object value) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        try {
            RuntimeDelegate.HeaderDelegate headerDelegate = MuRuntimeDelegate.getInstance().createHeaderDelegate(value.getClass());
            return headerDelegate.toString(value);
        }
        catch (MuException e) {
            return value.toString();
        }
    }

    void executeInterceptors(List<WriterInterceptor> writerInterceptors) throws IOException {
        this.nextWriter = 0;
        this.writerInterceptors = writerInterceptors;
        this.proceed();
    }

    public void proceed() throws IOException, WebApplicationException {
        if (this.nextWriter < this.writerInterceptors.size()) {
            ++this.nextWriter;
            WriterInterceptor nextInterceptor = this.writerInterceptors.get(this.nextWriter - 1);
            List<Class<? extends Annotation>> filterBindings = ResourceClass.getNameBindingAnnotations(nextInterceptor.getClass());
            if (this.requestContext.methodHasAnnotations(filterBindings)) {
                nextInterceptor.aroundWriteTo((WriterInterceptorContext)this);
            }
        }
    }

    public Object getProperty(String name) {
        return this.requestContext.getProperty(name);
    }

    public Collection<String> getPropertyNames() {
        return this.requestContext.getPropertyNames();
    }

    public void setProperty(String name, Object object) {
        this.requestContext.setProperty(name, object);
    }

    public void removeProperty(String name) {
        this.requestContext.removeProperty(name);
    }

    public void setRequestContext(JaxRSRequest requestContext) {
        this.requestContext = requestContext;
    }

    public String toString() {
        return this.getStatusInfo().toString();
    }

    static {
        MuRuntimeDelegate.ensureSet();
    }

    private static class CustomStatus
    implements Response.StatusType {
        private final String reason;
        private final Response.Status.Family family;
        private final int code;

        private CustomStatus(Response.Status.Family family, int code, String reason) {
            this.reason = reason;
            this.family = family;
            this.code = code;
        }

        public int getStatusCode() {
            return this.code;
        }

        public Response.Status.Family getFamily() {
            return this.family;
        }

        public String getReasonPhrase() {
            return this.reason;
        }
    }

    public static class Builder
    extends Response.ResponseBuilder {
        static final Annotation[] EMPTY_ANNOTATIONS;
        private final MultivaluedMap<String, Object> headers = new LowercasedMultivaluedHashMap();
        private final List<Link> linkHeaders = new ArrayList<Link>();
        private Response.StatusType status;
        private Object entity;
        private Annotation[] annotations = EMPTY_ANNOTATIONS;
        private NewCookie[] cookies = new NewCookie[0];
        private MediaType type;

        public Response build() {
            for (Link linkHeader : this.linkHeaders) {
                this.headers.add((Object)HeaderNames.LINK.toString(), (Object)linkHeader.toString());
            }
            if (this.type != null) {
                this.headers.putSingle((Object)HeaderNames.CONTENT_TYPE.toString(), (Object)this.type.toString());
            }
            return new JaxRSResponse(this.status, this.headers, ObjWithType.objType(this.entity), this.cookies, this.linkHeaders, this.annotations);
        }

        public Response.ResponseBuilder clone() {
            throw NotImplementedException.notYet();
        }

        public Response.ResponseBuilder status(int code) {
            return this.status(code, null);
        }

        public Response.ResponseBuilder status(int code, String reasonPhrase) {
            if (code < 100 || code > 599) {
                throw new IllegalArgumentException("Status must be between 100 and 599, but was " + code);
            }
            this.status = Response.Status.fromStatusCode((int)code);
            if (this.status == null || reasonPhrase != null) {
                this.status = new CustomStatus(Response.Status.Family.familyOf((int)code), code, reasonPhrase);
            }
            return this;
        }

        public Response.ResponseBuilder entity(Object entity) {
            return this.entity(entity, EMPTY_ANNOTATIONS);
        }

        public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
            this.entity = entity;
            this.annotations = annotations;
            return this;
        }

        public Response.ResponseBuilder allow(String ... methods) {
            if (methods == null || methods.length == 1 && methods[0] == null) {
                return this.allow((Set<String>)null);
            }
            return this.allow(new HashSet<String>(Arrays.asList(methods)));
        }

        public Response.ResponseBuilder allow(Set<String> methods) {
            if (methods == null) {
                return this.setHeader((CharSequence)HttpHeaderNames.ALLOW, null, true);
            }
            StringBuilder allow = new StringBuilder();
            for (String m : methods) {
                this.append(allow, true, m);
            }
            return this.setHeader((CharSequence)HttpHeaderNames.ALLOW, allow.toString(), true);
        }

        private void append(StringBuilder sb, boolean v, String s) {
            if (v) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
        }

        public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
            return this.setHeader(HeaderNames.CACHE_CONTROL, cacheControl.toString(), false);
        }

        public Response.ResponseBuilder encoding(String encoding) {
            return this.setHeader(HeaderNames.CONTENT_ENCODING, encoding, false);
        }

        private Response.ResponseBuilder setHeader(CharSequence name, Object value, boolean append) {
            if (value instanceof Iterable) {
                ((Iterable)value).forEach(v -> this.setHeader(name, v, append));
            } else if (value == null) {
                this.headers.remove((Object)name.toString());
            } else if (append) {
                this.headers.add((Object)name.toString(), value);
            } else {
                this.headers.putSingle((Object)name.toString(), value);
            }
            return this;
        }

        public Response.ResponseBuilder header(String name, Object value) {
            return this.setHeader(name, value, true);
        }

        public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
            this.headers.clear();
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    this.headers.add((Object)((String)entry.getKey()), entry.getValue());
                }
            }
            return this;
        }

        public Response.ResponseBuilder language(String language) {
            return this.setHeader(HeaderNames.CONTENT_LANGUAGE, language, false);
        }

        public Response.ResponseBuilder language(Locale language) {
            return this.language(language == null ? null : language.toLanguageTag());
        }

        public Response.ResponseBuilder type(MediaType type) {
            this.type = type;
            return this;
        }

        public Response.ResponseBuilder type(String type) {
            if (type == null) {
                this.type = null;
                return this;
            }
            return this.type(MediaType.valueOf((String)type));
        }

        public Response.ResponseBuilder variant(Variant variant) {
            this.language(variant == null ? null : variant.getLanguage());
            this.type(variant == null ? null : variant.getMediaType());
            this.encoding(variant == null ? null : variant.getEncoding());
            return this;
        }

        public Response.ResponseBuilder contentLocation(URI location) {
            return this.setHeader(HeaderNames.CONTENT_LOCATION, location, false);
        }

        public Response.ResponseBuilder cookie(NewCookie ... cookies) {
            this.cookies = cookies;
            if (cookies == null) {
                this.headers.remove((Object)HeaderNames.SET_COOKIE.toString());
            }
            return this;
        }

        public Response.ResponseBuilder expires(Date expires) {
            return this.setHeader(HeaderNames.EXPIRES, expires, false);
        }

        public Response.ResponseBuilder lastModified(Date lastModified) {
            return this.setHeader(HeaderNames.LAST_MODIFIED, lastModified, false);
        }

        public Response.ResponseBuilder location(URI location) {
            return this.setHeader(HeaderNames.LOCATION, location, false);
        }

        public Response.ResponseBuilder tag(EntityTag tag) {
            return this.setHeader(HeaderNames.ETAG, tag, false);
        }

        public Response.ResponseBuilder tag(String tag) {
            return this.tag(new EntityTag(tag));
        }

        public Response.ResponseBuilder variants(Variant ... variants) {
            return this.variants(Arrays.asList(variants));
        }

        public Response.ResponseBuilder variants(List<Variant> variants) {
            for (Variant variant : variants) {
                if (variant == null) {
                    this.headers.remove((Object)"vary");
                    continue;
                }
                List existing = (List)this.headers.get((Object)"vary");
                if (existing == null) {
                    existing = Collections.emptyList();
                }
                if (variant.getMediaType() != null && !existing.contains("content-type")) {
                    this.headers.add((Object)"vary", (Object)"content-type");
                }
                if (variant.getLanguage() != null && !existing.contains("content-language")) {
                    this.headers.add((Object)"vary", (Object)"content-language");
                }
                if (variant.getEncoding() == null || existing.contains("content-encoding")) continue;
                this.headers.add((Object)"vary", (Object)"content-encoding");
            }
            return this;
        }

        public Response.ResponseBuilder links(Link ... links) {
            if (links == null) {
                this.linkHeaders.clear();
            } else {
                this.linkHeaders.addAll(Arrays.asList(links));
            }
            return this;
        }

        public Response.ResponseBuilder link(URI uri, String rel) {
            Link link = Link.fromUri((URI)uri).rel(rel).build(new Object[0]);
            this.linkHeaders.add(link);
            return this;
        }

        public Response.ResponseBuilder link(String uri, String rel) {
            return this.link(URI.create(uri), rel);
        }

        static {
            MuRuntimeDelegate.ensureSet();
            EMPTY_ANNOTATIONS = new Annotation[0];
        }
    }
}

