/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.MuRequest;
import io.muserver.rest.EmptyInputStream;
import java.io.IOException;
import java.io.InputStream;

class LazyAccessInputStream
extends InputStream {
    private final MuRequest request;
    private InputStream inputStream;

    LazyAccessInputStream(MuRequest request) {
        this.request = request;
    }

    private InputStream in() {
        if (this.inputStream == null) {
            this.inputStream = this.request.inputStream().orElse(EmptyInputStream.INSTANCE);
        }
        return this.inputStream;
    }

    @Override
    public int read() throws IOException {
        return this.in().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in().available();
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in().mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in().reset();
    }

    @Override
    public boolean markSupported() {
        return this.in().markSupported();
    }
}

