/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.ParameterizedHeaderWithValue;
import io.muserver.rest.MuRuntimeDelegate;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

class LinkHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<Link> {
    private static final RuntimeDelegate.HeaderDelegate<Link> HEADER_DELEGATE;

    LinkHeaderDelegate() {
    }

    public Link fromString(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        List<ParameterizedHeaderWithValue> hList = ParameterizedHeaderWithValue.fromString(value);
        if (hList.isEmpty()) {
            throw new IllegalArgumentException("Could not parse link value");
        }
        ParameterizedHeaderWithValue h = hList.get(0);
        String uri = h.value();
        if (!uri.startsWith("<") || !uri.endsWith(">")) {
            throw new IllegalArgumentException("Link was not a valid link");
        }
        Map<String, String> parma = h.parameters();
        Link.Builder builder = new MuLinkBuilder().uri(uri.substring(1, uri.length() - 1)).rel(parma.get("rel")).title(parma.get("title")).type(parma.get("type"));
        for (Map.Entry<String, String> entry : parma.entrySet()) {
            String key = entry.getKey();
            if ("rel".equals(key) || "title".equals(key) || "type".equals(key)) continue;
            builder.param(key, entry.getValue());
        }
        return builder.build(new Object[0]);
    }

    public String toString(Link value) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(value.getUri().toString()).append(">");
        if (value.getRels().size() > 0) {
            sb.append("; rel=\"").append(String.join((CharSequence)" ", value.getRels())).append("\"");
        }
        LinkHeaderDelegate.app(sb, "title", value.getTitle());
        LinkHeaderDelegate.app(sb, "type", value.getType());
        for (Map.Entry entry : value.getParams().entrySet()) {
            LinkHeaderDelegate.app(sb, (String)entry.getKey(), (String)entry.getValue());
        }
        return sb.toString();
    }

    private static void app(StringBuilder sb, String key, String value) {
        if (value != null && !value.isEmpty()) {
            sb.append("; ").append(key).append("=\"").append(value.replace("\"", "\\\"")).append("\"");
        }
    }

    static {
        MuRuntimeDelegate.ensureSet();
        HEADER_DELEGATE = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);
    }

    static class MuLinkBuilder
    implements Link.Builder {
        private UriBuilder uri;
        private List<String> rels;
        private String title;
        private String type;
        private Map<String, String> params;
        private URI baseUri;

        MuLinkBuilder() {
        }

        public Link.Builder link(Link link) {
            this.uri = link.getUriBuilder();
            this.rels = link.getRels();
            this.title = link.getTitle();
            this.type = link.getType();
            this.params = link.getParams();
            return this;
        }

        public Link.Builder link(String link) {
            return this.link((Link)HEADER_DELEGATE.fromString(link));
        }

        public Link.Builder uri(URI uri) {
            this.uri = UriBuilder.fromUri((URI)uri);
            return this;
        }

        public Link.Builder uri(String uri) {
            this.uri = UriBuilder.fromUri((String)uri);
            return this;
        }

        public Link.Builder baseUri(URI uri) {
            this.baseUri = uri;
            return this;
        }

        public Link.Builder baseUri(String uri) {
            return this.baseUri(URI.create(uri));
        }

        public Link.Builder uriBuilder(UriBuilder uriBuilder) {
            this.uri = uriBuilder;
            return this;
        }

        public Link.Builder rel(String rel) {
            if (rel == null || rel.isEmpty()) {
                return this;
            }
            if (this.rels == null) {
                this.rels = new ArrayList<String>();
            }
            this.rels.add(rel);
            return this;
        }

        public Link.Builder title(String title) {
            this.title = title;
            return this;
        }

        public Link.Builder type(String type) {
            this.type = type;
            return this;
        }

        public Link.Builder param(String name, String value) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(name, value);
            return this;
        }

        public Link build(Object ... values) {
            return this.buildRelativized(null, values);
        }

        public Link buildRelativized(URI relativeTo, Object ... values) {
            if (this.uri == null) {
                throw new UriBuilderException("No URI has been set");
            }
            URI built = this.uri.build(values);
            if (this.baseUri != null) {
                built = this.baseUri.resolve(built);
            }
            if (relativeTo != null) {
                built = relativeTo.relativize(built);
            }
            return new MuLink(built, Mutils.coalesce(this.rels, Collections.emptyList()), this.title, this.type, Mutils.coalesce(this.params, Collections.emptyMap()));
        }
    }

    static class MuLink
    extends Link {
        private final URI uri;
        private final List<String> rels;
        private final String title;
        private final String type;
        private final Map<String, String> params;

        MuLink(URI uri, List<String> rels, String title, String type, Map<String, String> params) {
            Mutils.notNull("uri", uri);
            Mutils.notNull("rels", rels);
            Mutils.notNull("params", params);
            this.uri = uri;
            this.rels = rels;
            this.title = title;
            this.type = type;
            this.params = params;
        }

        public URI getUri() {
            return this.uri;
        }

        public UriBuilder getUriBuilder() {
            return UriBuilder.fromUri((URI)this.uri);
        }

        public String getRel() {
            return this.rels.isEmpty() ? null : this.rels.get(0);
        }

        public List<String> getRels() {
            return this.rels;
        }

        public String getTitle() {
            return this.title;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, String> getParams() {
            return this.params;
        }

        public String toString() {
            return HEADER_DELEGATE.toString((Object)this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MuLink muLink = (MuLink)((Object)o);
            return this.uri.equals(muLink.uri) && Objects.equals(this.rels, muLink.rels) && Objects.equals(this.title, muLink.title) && Objects.equals(this.type, muLink.type) && Objects.equals(this.params, muLink.params);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.rels, this.title, this.type, this.params);
        }
    }
}

