/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.rest.MuUriBuilder;
import io.muserver.rest.ReadOnlyMultivaluedMap;
import io.muserver.rest.UriPattern;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

class MuPathSegment
implements PathSegment {
    private final String path;
    private final MultivaluedMap<String, String> params;

    MuPathSegment(String path, MultivaluedMap<String, String> params) {
        this.params = params;
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        return this.params;
    }

    public String toString() {
        return this.path + this.getMatrixString(s -> s);
    }

    public String toString(Function<String, String> encodeFunction) {
        String path = encodeFunction.apply(this.path);
        return this.params.isEmpty() ? path : path + this.getMatrixString(encodeFunction);
    }

    private String getMatrixString(Function<String, String> encodeFunction) {
        if (this.params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List entries = this.params.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        for (Map.Entry param : entries) {
            String encodedKey = encodeFunction.apply((String)param.getKey());
            for (String val : (List)param.getValue()) {
                sb.append(';').append(encodedKey).append('=').append(encodeFunction.apply(val));
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MuPathSegment that = (MuPathSegment)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.params);
    }

    public List<String> pathParameters() {
        if (!this.path.contains("{") && this.params.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> pathParams = new ArrayList<String>(UriPattern.uriTemplateToRegex(this.path).namedGroups());
        for (Map.Entry matrixEntry : this.params.entrySet()) {
            List<String> matrixKeys = UriPattern.uriTemplateToRegex((String)matrixEntry.getKey()).namedGroups();
            for (String matrixKey : matrixKeys) {
                if (pathParams.contains(matrixKey)) continue;
                pathParams.add(matrixKey);
            }
            for (String matrixValue : (List)matrixEntry.getValue()) {
                List<String> matrixValues = UriPattern.uriTemplateToRegex(matrixValue).namedGroups();
                for (String value : matrixValues) {
                    if (pathParams.contains(value)) continue;
                    pathParams.add(value);
                }
            }
        }
        return pathParams;
    }

    public List<MuPathSegment> resolve(String name, String value, boolean encodeSlashInPath) {
        String newPath = MuUriBuilder.resolve(this.path, name, value);
        MultivaluedMap newParams = new MultivaluedMap();
        for (Map.Entry matrixParam : this.params.entrySet()) {
            newParams.put((Object)MuUriBuilder.resolve((String)matrixParam.getKey(), name, value), ((List)matrixParam.getValue()).stream().map(mv -> MuUriBuilder.resolve(mv, name, value)).collect(Collectors.toList()));
        }
        if (encodeSlashInPath) {
            return Collections.singletonList(new MuPathSegment(newPath, (MultivaluedMap<String, String>)newParams));
        }
        String[] newPaths = newPath.split("/");
        ArrayList<MuPathSegment> list = new ArrayList<MuPathSegment>();
        for (int i = 0; i < newPaths.length; ++i) {
            String s = newPaths[i];
            MultivaluedMap p = i == 0 ? newParams : ReadOnlyMultivaluedMap.empty();
            MuPathSegment muPathSegment = new MuPathSegment(s, p);
            list.add(muPathSegment);
        }
        return list;
    }

    MuPathSegment toEncoded() {
        MultivaluedHashMap copy = new MultivaluedHashMap();
        for (Map.Entry entry : this.params.entrySet()) {
            copy.put((Object)Mutils.urlEncode((String)entry.getKey()), ((List)entry.getValue()).stream().map(Mutils::urlEncode).collect(Collectors.toList()));
        }
        return new MuPathSegment(Mutils.urlEncode(this.path), (MultivaluedMap<String, String>)copy);
    }
}

