/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.HeaderNames;
import io.muserver.MuException;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.rest.CacheControlHeaderDelegate;
import io.muserver.rest.CookieHeaderDelegate;
import io.muserver.rest.DateHeaderDelegate;
import io.muserver.rest.EntityTagDelegate;
import io.muserver.rest.JaxRSResponse;
import io.muserver.rest.JaxSseImpl;
import io.muserver.rest.LinkHeaderDelegate;
import io.muserver.rest.MediaTypeHeaderDelegate;
import io.muserver.rest.MuUriBuilder;
import io.muserver.rest.MuVariantListBuilder;
import io.muserver.rest.NewCookieHeaderDelegate;
import io.muserver.rest.SseBroadcasterImpl;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseBroadcaster;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MuRuntimeDelegate
extends RuntimeDelegate {
    private static MuRuntimeDelegate singleton;
    private final Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates = new HashMap();
    public static final String MU_REQUEST_PROPERTY = "io.muserver.MU_REQUEST";
    public static final String RESOURCE_INFO_PROPERTY = "io.muserver.RESOURCE_INFO";

    public static synchronized RuntimeDelegate ensureSet() {
        if (singleton == null) {
            singleton = new MuRuntimeDelegate();
            RuntimeDelegate.setInstance((RuntimeDelegate)singleton);
        }
        return singleton;
    }

    private MuRuntimeDelegate() {
        this.headerDelegates.put(MediaType.class, new MediaTypeHeaderDelegate());
        this.headerDelegates.put(CacheControl.class, new CacheControlHeaderDelegate());
        this.headerDelegates.put(NewCookie.class, new NewCookieHeaderDelegate());
        this.headerDelegates.put(Cookie.class, new CookieHeaderDelegate());
        this.headerDelegates.put(EntityTag.class, new EntityTagDelegate());
        this.headerDelegates.put(Link.class, new LinkHeaderDelegate());
        this.headerDelegates.put(Date.class, new DateHeaderDelegate());
    }

    public static int connectedSinksCount(SseBroadcaster broadcaster) {
        Mutils.notNull("broadcaster", broadcaster);
        if (broadcaster instanceof SseBroadcasterImpl) {
            return ((SseBroadcasterImpl)broadcaster).connectedSinksCount();
        }
        throw new IllegalArgumentException("The given broadcaster was not created by MuServer. It was of type " + broadcaster.getClass());
    }

    public static void writeResponseHeaders(URI requestUri, Response from, MuResponse to, boolean isHttp1) {
        for (Map.Entry entry : from.getStringHeaders().entrySet()) {
            String key = (String)entry.getKey();
            if (!isHttp1 && key.equalsIgnoreCase("connection")) continue;
            List values = (List)entry.getValue();
            if (key.equalsIgnoreCase("location")) {
                URI location;
                if (values.size() != 1) {
                    throw new ServerErrorException("A location response header must have only one value. Received " + String.join((CharSequence)", ", values), 500);
                }
                try {
                    location = URI.create((String)values.get(0));
                }
                catch (IllegalArgumentException e) {
                    throw new ServerErrorException("Invalid redirect location: " + (String)values.get(0) + " - " + e.getMessage(), 500);
                }
                to.headers().add(key, (Object)requestUri.resolve(location).toString());
                continue;
            }
            to.headers().add(key, (Iterable<?>)values);
        }
        for (NewCookie cookie : from.getCookies().values()) {
            to.headers().add(HeaderNames.SET_COOKIE, (Object)cookie.toString());
        }
    }

    public UriBuilder createUriBuilder() {
        return new MuUriBuilder();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new JaxRSResponse.Builder();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new MuVariantListBuilder();
    }

    public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        throw new MuException("MuServer does not support instantiation of application classes");
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) throws IllegalArgumentException {
        RuntimeDelegate.HeaderDelegate headerDelegate = this.headerDelegates.get(type);
        if (headerDelegate != null) {
            return headerDelegate;
        }
        throw new MuException("MuServer does not support converting " + type.getName());
    }

    public Link.Builder createLinkBuilder() {
        return new LinkHeaderDelegate.MuLinkBuilder();
    }

    public static Sse createSseFactory() {
        return new JaxSseImpl();
    }
}

