/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.rest.Authorizer;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;

class MuSecurityContext
implements SecurityContext {
    private final Principal principal;
    private final Authorizer authorizer;
    private final boolean isHttps;
    private final String authenticationScheme;
    static final MuSecurityContext notLoggedInHttpContext = new MuSecurityContext(null, (principal1, role) -> false, false, null);
    static final MuSecurityContext notLoggedInHttpsContext = new MuSecurityContext(null, (principal1, role) -> false, true, null);

    MuSecurityContext(Principal principal, Authorizer authorizer, boolean isHttps, String authenticationScheme) {
        this.principal = principal;
        this.authorizer = authorizer;
        this.isHttps = isHttps;
        this.authenticationScheme = authenticationScheme;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.authorizer.isInRole(this.principal, role);
    }

    public boolean isSecure() {
        return this.isHttps;
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }
}

