/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.rest.MuPathSegment;
import io.muserver.rest.MuRuntimeDelegate;
import io.muserver.rest.ReadOnlyMultivaluedMap;
import io.muserver.rest.RequestMatcher;
import io.netty.handler.codec.http.QueryStringDecoder;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MuUriInfo
implements UriInfo {
    private final URI baseUri;
    private final URI requestUri;
    private final String encodedRelativePath;
    private final RequestMatcher.MatchedMethod matchedMethod;

    MuUriInfo(URI baseUri, URI requestUri, String encodedRelativePath, RequestMatcher.MatchedMethod matchedMethod) {
        this.baseUri = baseUri;
        this.requestUri = requestUri;
        this.encodedRelativePath = encodedRelativePath;
        this.matchedMethod = matchedMethod;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        return decode ? Mutils.urlDecode(this.encodedRelativePath) : this.encodedRelativePath;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return MuUriInfo.pathStringToSegments(this.getPath(decode), false).collect(Collectors.toList());
    }

    static Stream<MuPathSegment> pathStringToSegments(String path, boolean encodeSlashes) {
        Stream<String> stream = encodeSlashes ? Stream.of(path) : Stream.of(path.split("/"));
        return stream.filter(s -> !s.isEmpty()).map(s -> {
            String[] segments = s.split(";");
            MultivaluedHashMap params = new MultivaluedHashMap();
            for (int i = 1; i < segments.length; ++i) {
                String[] nv = segments[i].split("=");
                String paramName = nv[0];
                if (nv.length == 1) {
                    params.add((Object)paramName, (Object)"");
                    continue;
                }
                Object[] vals = nv[1].split(",");
                params.addAll((Object)paramName, vals);
            }
            return new MuPathSegment(segments[0], (MultivaluedMap<String, String>)params);
        });
    }

    public URI getRequestUri() {
        return this.requestUri;
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.requestUri);
    }

    public URI getAbsolutePath() {
        return this.getBaseUri().resolve(this.getPath(false));
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.baseUri);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (this.matchedMethod == null) {
            return ReadOnlyMultivaluedMap.empty();
        }
        Map<String, PathSegment> pp = this.matchedMethod.pathParams;
        if (pp.isEmpty()) {
            return ReadOnlyMultivaluedMap.empty();
        }
        MultivaluedHashMap all = new MultivaluedHashMap(pp.size());
        for (Map.Entry<String, PathSegment> entry : pp.entrySet()) {
            String param = entry.getKey();
            String path = entry.getValue().getPath();
            if (!all.containsKey((Object)param)) {
                all.put((Object)param, new ArrayList());
            }
            if (!decode) {
                path = Mutils.urlEncode(path);
            }
            ((List)all.get((Object)param)).add(path);
        }
        return ReadOnlyMultivaluedMap.readOnly(all);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        QueryStringDecoder qsd = new QueryStringDecoder(this.requestUri);
        MultivaluedHashMap all = new MultivaluedHashMap();
        if (decode) {
            all.putAll(qsd.parameters());
        } else {
            for (Map.Entry entry : qsd.parameters().entrySet()) {
                all.put((Object)((String)entry.getKey()), ((List)entry.getValue()).stream().map(Mutils::urlEncode).collect(Collectors.toList()));
            }
        }
        return ReadOnlyMultivaluedMap.readOnly(all);
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        RequestMatcher.MatchedMethod mm = this.matchedMethod;
        if (mm == null) {
            return Collections.emptyList();
        }
        ArrayList<String> matchedURIs = new ArrayList<String>();
        matchedURIs.add(decode ? Mutils.urlDecode(this.encodedRelativePath) : this.encodedRelativePath);
        String methodSpecific = mm.pathMatch.regexMatcher().group();
        String path = this.encodedRelativePath.replace("/" + methodSpecific, "");
        matchedURIs.add(decode ? Mutils.urlDecode(path) : path);
        return Collections.unmodifiableList(matchedURIs);
    }

    public List<Object> getMatchedResources() {
        return this.matchedMethod == null ? Collections.emptyList() : Collections.singletonList(this.matchedMethod.matchedClass.resourceClass.resourceInstance);
    }

    public URI resolve(URI relative) {
        return this.baseUri.resolve(relative);
    }

    public URI relativize(URI uri) {
        URI relToBase = this.baseUri.resolve(uri);
        URI requestUriDir = this.requestUri.resolve(URI.create("."));
        return requestUriDir.relativize(relToBase);
    }

    public String toString() {
        return this.getRequestUri().toString();
    }

    static {
        MuRuntimeDelegate.ensureSet();
    }
}

