/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.ContentTypes;
import io.muserver.Method;
import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.openapi.ComponentsObject;
import io.muserver.openapi.ComponentsObjectBuilder;
import io.muserver.openapi.MediaTypeObject;
import io.muserver.openapi.OpenAPIObject;
import io.muserver.openapi.OpenAPIObjectBuilder;
import io.muserver.openapi.OperationObject;
import io.muserver.openapi.OperationObjectBuilder;
import io.muserver.openapi.ParameterObject;
import io.muserver.openapi.PathItemObject;
import io.muserver.openapi.PathItemObjectBuilder;
import io.muserver.openapi.PathsObjectBuilder;
import io.muserver.openapi.RequestBodyObjectBuilder;
import io.muserver.openapi.ResponsesObjectBuilder;
import io.muserver.openapi.SchemaObject;
import io.muserver.openapi.ServerObjectBuilder;
import io.muserver.openapi.TagObject;
import io.muserver.rest.CORSConfig;
import io.muserver.rest.HtmlDocumentor;
import io.muserver.rest.ResourceClass;
import io.muserver.rest.ResourceMethod;
import io.muserver.rest.ResourceMethodParam;
import io.muserver.rest.SchemaObjectCustomizer;
import io.muserver.rest.SchemaReference;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class OpenApiDocumentor
implements MuHandler {
    private final List<ResourceClass> roots;
    private final String openApiJsonUrl;
    private final OpenAPIObject openAPIObject;
    private final String openApiHtmlUrl;
    private final String openApiHtmlCss;
    private final CORSConfig corsConfig;
    private final List<SchemaReference> customSchemas;
    private final SchemaObjectCustomizer schemaObjectCustomizer;
    private final List<ParamConverterProvider> paramConverterProviders;

    OpenApiDocumentor(List<ResourceClass> roots, String openApiJsonUrl, String openApiHtmlUrl, OpenAPIObject openAPIObject, String openApiHtmlCss, CORSConfig corsConfig, List<SchemaReference> customSchemas, SchemaObjectCustomizer schemaObjectCustomizer, List<ParamConverterProvider> paramConverterProviders) {
        this.customSchemas = customSchemas;
        this.schemaObjectCustomizer = schemaObjectCustomizer;
        this.paramConverterProviders = paramConverterProviders;
        Mutils.notNull("openAPIObject", openAPIObject);
        this.corsConfig = corsConfig;
        this.roots = roots;
        this.openApiJsonUrl = openApiJsonUrl == null ? null : Mutils.trim(openApiJsonUrl, "/");
        this.openApiHtmlUrl = openApiHtmlUrl == null ? null : Mutils.trim(openApiHtmlUrl, "/");
        this.openAPIObject = openAPIObject;
        this.openApiHtmlCss = openApiHtmlCss;
    }

    @Override
    public boolean handle(MuRequest request, MuResponse response) throws Exception {
        block25: {
            BufferedWriter writer;
            OutputStreamWriter osw;
            String relativePath = Mutils.trim(request.relativePath(), "/");
            if (request.method() != Method.GET || !relativePath.equals(this.openApiJsonUrl) && !relativePath.equals(this.openApiHtmlUrl)) {
                return false;
            }
            ArrayList<TagObject> tags = new ArrayList<TagObject>();
            LinkedHashMap<String, PathItemObjectBuilder> pathItemBuilders = new LinkedHashMap<String, PathItemObjectBuilder>();
            for (ResourceClass root : this.roots) {
                this.addResourceClass(0, "", tags, pathItemBuilders, root);
            }
            Map<String, PathItemObject> pathItems = pathItemBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((PathItemObjectBuilder)v.getValue()).build()));
            ComponentsObject components = this.openAPIObject.components();
            if (!this.customSchemas.isEmpty()) {
                ComponentsObjectBuilder componentsObjectBuilder = ComponentsObjectBuilder.componentsObject(components);
                HashMap<String, SchemaObject> schemas = components != null && components.schemas() != null ? components.schemas() : new HashMap<String, SchemaObject>();
                for (SchemaReference customSchema : this.customSchemas) {
                    if (schemas.containsKey(customSchema.id)) continue;
                    schemas.put(customSchema.id, customSchema.schema);
                }
                components = componentsObjectBuilder.withSchemas(schemas).build();
            }
            OpenAPIObjectBuilder api = OpenAPIObjectBuilder.openAPIObject().withInfo(this.openAPIObject.info()).withExternalDocs(this.openAPIObject.externalDocs()).withSecurity(this.openAPIObject.security()).withComponents(components).withServers(this.openAPIObject.servers() != null ? this.openAPIObject.servers() : (request.contextPath().length() > 0 ? Collections.singletonList(ServerObjectBuilder.serverObject().withUrl(request.contextPath()).build()) : null)).withPaths(PathsObjectBuilder.pathsObject().withPathItemObjects(pathItems).build()).withTags(tags);
            OpenAPIObject builtApi = api.build();
            if (relativePath.equals(this.openApiJsonUrl)) {
                response.contentType(ContentTypes.APPLICATION_JSON);
                this.corsConfig.writeHeadersInternal(request, response, Collections.emptySet());
                response.headers().set("Access-Control-Allow-Methods", (Object)"GET");
                osw = new OutputStreamWriter(response.outputStream(), StandardCharsets.UTF_8);
                try {
                    writer = new BufferedWriter(osw, 8192);
                    try {
                        builtApi.writeJson(writer);
                        break block25;
                    }
                    finally {
                        writer.close();
                    }
                }
                finally {
                    osw.close();
                }
            }
            response.contentType(ContentTypes.TEXT_HTML_UTF8);
            response.headers().set("X-UA-Compatible", (Object)"IE=edge");
            osw = new OutputStreamWriter(response.outputStream(), StandardCharsets.UTF_8);
            try {
                writer = new BufferedWriter(osw, 8192);
                try {
                    new HtmlDocumentor(writer, builtApi, this.openApiHtmlCss, request.uri()).writeHtml();
                }
                finally {
                    writer.close();
                }
            }
            finally {
                osw.close();
            }
        }
        return true;
    }

    private void addResourceClass(int recursiveLevel, String parentResourcePath, List<TagObject> tags, Map<String, PathItemObjectBuilder> pathItems, ResourceClass root) {
        if (recursiveLevel == 5) {
            return;
        }
        if (!tags.contains(root.tag)) {
            tags.add(root.tag);
        }
        for (ResourceMethod method : root.resourceMethods) {
            LinkedHashMap<String, OperationObject> operations;
            if (method.isSubResourceLocator()) {
                ResourceClass rc = ResourceClass.forSubResourceLocator(method, method.methodHandle.getReturnType(), null, this.schemaObjectCustomizer, this.paramConverterProviders);
                String newParentResourcePath = Mutils.join(parentResourcePath, "/", method.resourceClass.pathPattern.pathWithoutRegex);
                this.addResourceClass(recursiveLevel + 1, newParentResourcePath, tags, pathItems, rc);
                continue;
            }
            String path = OpenApiDocumentor.getPathWithoutRegex(root, method, parentResourcePath);
            if (pathItems.containsKey(path)) {
                operations = pathItems.get(path).operations();
            } else {
                operations = new LinkedHashMap();
                PathItemObjectBuilder pathItem = PathItemObjectBuilder.pathItemObject().withOperations(operations);
                pathItems.put(path, pathItem);
            }
            List parameters = method.paramsIncludingLocators().stream().filter(p -> p.source.openAPIIn != null && p instanceof ResourceMethodParam.RequestBasedParam).map(ResourceMethodParam.RequestBasedParam.class::cast).map(p -> p.createDocumentationBuilder().build()).reduce(new ArrayList(), (parameterObjects, parameterObject) -> {
                if (parameterObjects.stream().noneMatch(existing -> existing.name().equals(parameterObject.name()) && existing.in().equals(parameterObject.in()))) {
                    parameterObjects.add(parameterObject);
                }
                return parameterObjects;
            }, (list1, list2) -> {
                list1.addAll(list2);
                return list1;
            });
            String opIdPath = OpenApiDocumentor.getPathWithoutRegex(root, method, parentResourcePath).replace("{", "_").replace("}", "_");
            String opPath = Mutils.trim(opIdPath, "/").replace("/", "_");
            String opKey = method.httpMethod.name().toLowerCase();
            OperationObject existing = (OperationObject)operations.get(opKey);
            if (existing == null) {
                existing = method.createOperationBuilder(this.customSchemas).withOperationId(method.httpMethod.name() + "_" + opPath).withTags(Collections.singletonList(root.tag.name())).withParameters(parameters).build();
            } else {
                OperationObject curOO = method.createOperationBuilder(this.customSchemas).build();
                ArrayList<ParameterObject> combinedParams = new ArrayList<ParameterObject>(existing.parameters());
                combinedParams.addAll(parameters);
                HashMap<String, MediaTypeObject> mergedContent = new HashMap<String, MediaTypeObject>();
                if (existing.requestBody() != null && existing.requestBody().content() != null) {
                    mergedContent.putAll(existing.requestBody().content());
                }
                if (curOO.requestBody() != null) {
                    mergedContent.putAll(curOO.requestBody().content());
                }
                OperationObjectBuilder operationObjectBuilder = OperationObjectBuilder.builderFrom(existing).withParameters(combinedParams).withResponses(ResponsesObjectBuilder.mergeResponses(existing.responses(), curOO.responses()).build()).withRequestBody(RequestBodyObjectBuilder.requestBodyObject().withRequired(existing.requestBody() != null && existing.requestBody().required() && curOO.requestBody() != null && curOO.requestBody().required()).withDescription(Mutils.coalesce(existing.description(), curOO.description())).withContent(mergedContent).build());
                if (existing.summary() == null && existing.description() == null) {
                    operationObjectBuilder.withSummary(curOO.summary()).withDescription(curOO.description());
                }
                existing = operationObjectBuilder.build();
            }
            operations.put(opKey, existing);
        }
    }

    static String getPathWithoutRegex(ResourceClass rc, ResourceMethod rm, String parentResourcePath) {
        return "/" + Mutils.trim(Mutils.join(parentResourcePath, "/", Mutils.join(rc.pathPattern == null ? null : rc.pathPattern.pathWithoutRegex, "/", rm.pathPattern == null ? null : rm.pathPattern.pathWithoutRegex)), "/");
    }
}

