/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.HeaderNames;
import io.muserver.Method;
import io.muserver.MuRequest;
import io.muserver.rest.CombinedMediaType;
import io.muserver.rest.JaxRSRequest;
import io.muserver.rest.MediaTypeHeaderDelegate;
import io.muserver.rest.MuRuntimeDelegate;
import io.muserver.rest.NotMatchedException;
import io.muserver.rest.PathMatch;
import io.muserver.rest.ResourceClass;
import io.muserver.rest.ResourceMethod;
import io.muserver.rest.UriPattern;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.PathSegment;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class RequestMatcher {
    static final List<MediaType> WILDCARD_AS_LIST;
    private final List<ResourceClass> roots;

    RequestMatcher(List<ResourceClass> roots) {
        if (roots == null) {
            throw new NullPointerException("roots cannot be null");
        }
        this.roots = roots;
    }

    MatchedMethod findResourceMethod(JaxRSRequest requestContext, Method httpMethod, List<MediaType> acceptHeaders, Function<MatchedMethod, ResourceClass> subResourceLocator) throws NotAllowedException, NotAcceptableException, NotSupportedException, NotMatchedException {
        String path = requestContext.relativePath();
        Set<MatchedMethod> candidateMethods = this.getMatchedMethodsForPath(path, subResourceLocator);
        MuRequest req = requestContext.muRequest;
        String requestBodyContentType = req.headers().get(HeaderNames.CONTENT_TYPE);
        return this.stepThreeIdentifyTheMethodThatWillHandleTheRequest(httpMethod, candidateMethods, requestBodyContentType, acceptHeaders);
    }

    Set<MatchedMethod> getMatchedMethodsForPath(String path, Function<MatchedMethod, ResourceClass> subResourceLocator) throws NotMatchedException {
        StepOneOutput stepOneOutput = this.stepOneIdentifyASetOfCandidateRootResourceClassesMatchingTheRequest(path);
        URI methodURI = stepOneOutput.unmatchedGroup == null ? null : URI.create(UriPattern.trimSlashes(stepOneOutput.unmatchedGroup));
        return this.stepTwoObtainASetOfCandidateResourceMethodsForTheRequest(methodURI, stepOneOutput.candidates, subResourceLocator);
    }

    StepOneOutput stepOneIdentifyASetOfCandidateRootResourceClassesMatchingTheRequest(String uri) throws NotMatchedException {
        List candidates = this.roots.stream().map(rc -> new MatchedClass((ResourceClass)rc, rc.pathPattern.matcher(uri))).filter(rc -> {
            PathMatch matcher = rc.pathMatch;
            return matcher.prefixMatches() && (matcher.lastGroup() == null || !rc.resourceClass.subResourceMethods().isEmpty());
        }).sorted((o1, o2) -> {
            UriPattern o1pp = o1.resourceClass.pathPattern;
            UriPattern o2pp = o2.resourceClass.pathPattern;
            int c = Integer.compare(o2pp.numberOfLiterals, o1pp.numberOfLiterals);
            if (c == 0) {
                c = Integer.compare(o2pp.namedGroups().size(), o1pp.namedGroups().size());
            }
            if (c == 0) {
                c = Integer.compare(this.countNonDefaultGroups(o2.resourceClass.pathTemplate), this.countNonDefaultGroups(o1.resourceClass.pathTemplate));
            }
            return c;
        }).collect(Collectors.toList());
        if (candidates.isEmpty()) {
            throw new NotMatchedException();
        }
        UriPattern rMatch = ((MatchedClass)candidates.get((int)0)).resourceClass.pathPattern;
        String u = rMatch.matcher(uri).lastGroup();
        List<MatchedClass> c0 = candidates.stream().filter(rc -> rc.resourceClass.pathPattern.equalModuloVariableNames(rMatch)).collect(Collectors.toList());
        return new StepOneOutput(u, c0);
    }

    private Set<MatchedMethod> stepTwoObtainASetOfCandidateResourceMethodsForTheRequest(URI relativeUri, List<MatchedClass> candidateClasses, Function<MatchedMethod, ResourceClass> subResourceLocator) throws NotMatchedException {
        Collection<MatchedMethod> candidates;
        if (relativeUri == null && !(candidates = RequestMatcher.getNonLocatorMethods(candidateClasses, false)).isEmpty()) {
            return candidates;
        }
        candidates = new ArrayList();
        for (MatchedClass candidateClass : candidateClasses) {
            for (ResourceMethod resourceMethod : candidateClass.resourceClass.resourceMethods) {
                PathMatch matcher;
                if (!resourceMethod.isSubResource() && !resourceMethod.isSubResourceLocator() || relativeUri == null || !(matcher = resourceMethod.pathPattern.matcher(relativeUri)).fullyMatches() && (!resourceMethod.isSubResourceLocator() || !matcher.prefixMatches())) continue;
                HashMap<String, PathSegment> combinedParams = new HashMap<String, PathSegment>(candidateClass.pathMatch.segments());
                combinedParams.putAll(matcher.segments());
                candidates.add(new MatchedMethod(candidateClass, resourceMethod, combinedParams, matcher));
            }
        }
        if (candidates.isEmpty()) {
            throw new NotMatchedException();
        }
        candidates.sort((o1, o2) -> {
            ResourceMethod rm1 = o1.resourceMethod;
            ResourceMethod rm2 = o2.resourceMethod;
            int c = Integer.compare(rm2.pathPattern.numberOfLiterals, rm1.pathPattern.numberOfLiterals);
            if (c == 0) {
                c = Integer.compare(rm2.pathPattern.namedGroups().size(), rm1.pathPattern.namedGroups().size());
            }
            if (c == 0) {
                c = Integer.compare(this.countNonDefaultGroups(rm2.pathTemplate), this.countNonDefaultGroups(rm1.pathTemplate));
            }
            if (c == 0) {
                c = Boolean.compare(o1.resourceMethod.isSubResourceLocator(), o2.resourceMethod.isSubResourceLocator());
            }
            return c;
        });
        UriPattern matcher = ((MatchedMethod)candidates.get((int)0)).resourceMethod.pathPattern;
        Set<MatchedMethod> m = candidates.stream().filter(rm -> !rm.resourceMethod.isSubResourceLocator() && rm.resourceMethod.pathPattern.equals(matcher)).collect(Collectors.toSet());
        if (!m.isEmpty()) {
            return m;
        }
        Set l = candidates.stream().filter(rm -> rm.resourceMethod.isSubResourceLocator() && rm.resourceMethod.pathPattern.equals(matcher)).collect(Collectors.toSet());
        if (l.isEmpty()) {
            throw new NotMatchedException();
        }
        if (l.size() == 1) {
            MatchedMethod mm = (MatchedMethod)l.stream().findFirst().get();
            MatchedClass mc = new MatchedClass(subResourceLocator.apply(mm), mm.pathMatch);
            String remainingUrl = mm.pathMatch.lastGroup();
            return this.stepTwoObtainASetOfCandidateResourceMethodsForTheRequest(remainingUrl == null ? null : URI.create(remainingUrl), Collections.singletonList(mc), subResourceLocator);
        }
        throw new ServerErrorException("Multiple resource locators matched", 500);
    }

    private static Set<MatchedMethod> getNonLocatorMethods(List<MatchedClass> candidateClasses, boolean isSubResource) {
        HashSet<MatchedMethod> candidates = new HashSet<MatchedMethod>();
        for (MatchedClass mc : candidateClasses) {
            for (ResourceMethod resourceMethod : mc.resourceClass.resourceMethods) {
                if (resourceMethod.isSubResource() != isSubResource || resourceMethod.isSubResourceLocator()) continue;
                MatchedMethod matchedMethod = new MatchedMethod(mc, resourceMethod, mc.pathMatch.segments(), mc.pathMatch);
                candidates.add(matchedMethod);
            }
        }
        return candidates;
    }

    private MatchedMethod stepThreeIdentifyTheMethodThatWillHandleTheRequest(Method method, Set<MatchedMethod> candidates, String requestBodyContentType, List<MediaType> acceptHeaders) throws NotAllowedException, NotAcceptableException, NotSupportedException {
        List result = candidates.stream().filter(rm -> rm.resourceMethod.httpMethod == method).collect(Collectors.toList());
        if (result.isEmpty()) {
            List allowed = candidates.stream().map(c -> c.resourceMethod.httpMethod.name()).distinct().collect(Collectors.toList());
            throw new NotAllowedException((String)allowed.get(0), allowed.subList(1, allowed.size()).toArray(new String[0]));
        }
        MediaType requestBodyMediaType = requestBodyContentType == null ? MediaTypeHeaderDelegate.NONE : MediaType.valueOf((String)requestBodyContentType);
        if ((result = result.stream().filter(rm -> rm.resourceMethod.canConsume(requestBodyMediaType)).collect(Collectors.toList())).isEmpty()) {
            throw new NotSupportedException();
        }
        List<MediaType> clientAccepts = acceptHeaders.isEmpty() ? WILDCARD_AS_LIST : acceptHeaders;
        if ((result = result.stream().filter(rm -> rm.resourceMethod.canProduceFor(clientAccepts)).collect(Collectors.toList())).isEmpty()) {
            throw new NotAcceptableException();
        }
        if (result.size() == 1) {
            return (MatchedMethod)result.get(0);
        }
        List<MediaType> requestBodyTypeAsList = Collections.singletonList(requestBodyMediaType);
        return result.stream().max(Comparator.comparing(o -> RequestMatcher.bestMediaType(requestBodyTypeAsList, o.resourceMethod.effectiveConsumes)).thenComparing(o -> RequestMatcher.bestMediaType(clientAccepts, o.resourceMethod.effectiveProduces))).get();
    }

    private static CombinedMediaType bestMediaType(List<MediaType> requestedTypes, List<MediaType> serverProvided) {
        return serverProvided.stream().map(serverType -> requestedTypes.stream().map(clientType -> CombinedMediaType.s(clientType, serverType)).min(Comparator.naturalOrder()).get()).min(Comparator.naturalOrder()).get();
    }

    private int countNonDefaultGroups(String pathTemplate) {
        int count = 0;
        for (String bit : pathTemplate.split("/")) {
            if (!bit.startsWith("{") || !bit.endsWith("}") || !bit.contains(":")) continue;
            ++count;
        }
        return count;
    }

    static {
        MuRuntimeDelegate.ensureSet();
        WILDCARD_AS_LIST = Collections.singletonList(MediaType.WILDCARD_TYPE);
    }

    static class StepOneOutput {
        final String unmatchedGroup;
        final List<MatchedClass> candidates;

        StepOneOutput(String unmatchedGroup, List<MatchedClass> candidates) {
            this.unmatchedGroup = unmatchedGroup;
            this.candidates = candidates;
        }
    }

    static class MatchedMethod {
        final MatchedClass matchedClass;
        final ResourceMethod resourceMethod;
        final Map<String, PathSegment> pathParams;
        final PathMatch pathMatch;

        MatchedMethod(MatchedClass matchedClass, ResourceMethod resourceMethod, Map<String, PathSegment> pathParams, PathMatch pathMatch) {
            this.matchedClass = matchedClass;
            this.resourceMethod = resourceMethod;
            this.pathParams = pathParams;
            this.pathMatch = pathMatch;
        }

        public String toString() {
            return "MatchedMethod{resourceMethod=" + this.resourceMethod + ", pathParams=" + this.pathParams + '}';
        }

        public String getPathParam(String key) {
            PathSegment segment = this.pathParams.get(key);
            return segment == null ? null : segment.getPath();
        }
    }

    static class MatchedClass {
        final ResourceClass resourceClass;
        final PathMatch pathMatch;

        MatchedClass(ResourceClass resourceClass, PathMatch pathMatch) {
            this.resourceClass = resourceClass;
            this.pathMatch = pathMatch;
        }
    }
}

