/*
 * Decompiled with CFR 0.152.
 */
package io.muserver.rest;

import io.muserver.Mutils;
import io.muserver.rest.Jaxutils;
import io.muserver.rest.MuPathSegment;
import io.muserver.rest.MuUriInfo;
import io.muserver.rest.PathMatch;
import jakarta.ws.rs.core.PathSegment;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriPattern {
    static final String DEFAULT_CAPTURING_GROUP_PATTERN = "[^/]+?";
    static final String MATRIX_PARAMETERS_PATTERN = "(;[A-Za-z0-9-._~@!$&'()*+,=%]*)*";
    private final Pattern pattern;
    private final List<String> namedGroups;
    private final List<String> namedGroupRegexes;
    final int numberOfLiterals;
    final String pathWithoutRegex;

    private UriPattern(Pattern pattern, List<String> namedGroups, List<String> namedGroupRegexes, int numberOfLiterals, String pathWithoutRegex) {
        this.pattern = pattern;
        this.namedGroups = Collections.unmodifiableList(namedGroups);
        this.namedGroupRegexes = namedGroupRegexes;
        this.numberOfLiterals = numberOfLiterals;
        this.pathWithoutRegex = pathWithoutRegex;
    }

    String regexFor(String name) {
        int i = this.namedGroups.indexOf(name);
        if (i == -1) {
            return null;
        }
        return this.namedGroupRegexes.get(i);
    }

    public String pattern() {
        return this.pattern.pattern();
    }

    public List<String> namedGroups() {
        return this.namedGroups;
    }

    public PathMatch matcher(URI input) {
        return this.matcher(input.getRawPath());
    }

    public PathMatch matcher(String rawPath) {
        Matcher matcher;
        if (rawPath.startsWith("/")) {
            rawPath = rawPath.substring(1);
        }
        if ((matcher = this.pattern.matcher(rawPath)).matches()) {
            HashMap<String, PathSegment> params = new HashMap<String, PathSegment>();
            for (String namedGroup : this.namedGroups) {
                MuPathSegment segment = MuUriInfo.pathStringToSegments(Mutils.urlDecode(matcher.group(namedGroup)), true).findFirst().orElse(null);
                if (segment == null) continue;
                params.put(namedGroup, segment);
            }
            return new PathMatch(true, params, matcher);
        }
        return new PathMatch(false, Collections.emptyMap(), matcher);
    }

    public String toString() {
        return this.pattern.toString();
    }

    public static UriPattern uriTemplateToRegex(String template) throws IllegalArgumentException {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        template = UriPattern.trimSlashes(template);
        ArrayList<String> groupNames = new ArrayList<String>();
        ArrayList<String> namedGroupRegexes = new ArrayList<String>();
        StringBuilder simplePath = new StringBuilder("/");
        StringBuilder regex = new StringBuilder();
        int numberOfLiterals = 0;
        int curIndex = 0;
        int loop = 0;
        while (curIndex < template.length()) {
            ++loop;
            int startRegex = template.indexOf(123, curIndex);
            if (startRegex != curIndex) {
                int endIndex = startRegex == -1 ? template.length() : startRegex;
                String literal = template.substring(curIndex, endIndex);
                numberOfLiterals += literal.length();
                if (literal.equals("/")) {
                    regex.append('/');
                    simplePath.append('/');
                } else if (!literal.contains("/")) {
                    regex.append(UriPattern.escapeRegex(literal)).append(MATRIX_PARAMETERS_PATTERN);
                    simplePath.append(literal);
                } else {
                    String[] segments;
                    for (String segment : segments = literal.split("/")) {
                        if (!segment.isEmpty()) {
                            regex.append(UriPattern.escapeRegex(segment)).append(MATRIX_PARAMETERS_PATTERN);
                            simplePath.append(segment);
                        }
                        regex.append('/');
                        simplePath.append('/');
                    }
                }
                curIndex = endIndex;
            } else {
                String groupRegex;
                String bit;
                String groupName;
                int endOfRegex = template.indexOf(125, curIndex);
                if (endOfRegex == -1) {
                    throw new IllegalArgumentException("Unclosed { character in path " + template);
                }
                if ((groupName = (bit = template.substring(curIndex, ++endOfRegex)).substring(1, bit.length() - 1).trim()).contains(":")) {
                    String[] nameInfo = groupName.split("\\s*:\\s*", 2);
                    groupName = nameInfo[0];
                    groupRegex = nameInfo[1];
                } else {
                    groupRegex = DEFAULT_CAPTURING_GROUP_PATTERN;
                }
                if (!groupNames.contains(groupName)) {
                    groupNames.add(groupName);
                    namedGroupRegexes.add(groupRegex);
                    regex.append("(?<").append(groupName).append(">").append(groupRegex).append(MATRIX_PARAMETERS_PATTERN).append(')');
                } else {
                    regex.append("\\k<").append(groupName).append('>');
                }
                simplePath.append('{').append(groupName).append('}');
                curIndex = endOfRegex;
            }
            if (loop <= 100) continue;
            break;
        }
        if (regex.length() > 0 && regex.lastIndexOf("/") == regex.length() - 1) {
            regex.delete(regex.length() - 1, regex.length());
        }
        regex.append("(/.*)?");
        return new UriPattern(Pattern.compile(regex.toString()), groupNames, namedGroupRegexes, numberOfLiterals, simplePath.toString());
    }

    private static String escapeRegex(String literal) {
        if (literal.contains("%")) {
            literal = Jaxutils.leniantUrlDecode(literal);
        }
        return Pattern.quote(Mutils.urlEncode(literal));
    }

    static String trimSlashes(String url) {
        if (url.equals("/")) {
            return "";
        }
        boolean start = url.startsWith("/");
        boolean end = url.endsWith("/");
        if (!start && !end) {
            return url;
        }
        return url.substring(start ? 1 : 0, end ? url.length() - 1 : url.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriPattern that = (UriPattern)o;
        return Objects.equals(this.pattern.pattern(), that.pattern.pattern());
    }

    public int hashCode() {
        return Objects.hash(this.pattern.pattern());
    }

    boolean equalModuloVariableNames(UriPattern other) {
        String regex = "\\(\\?<[^>]+>";
        String thisNormalised = this.pattern().replaceAll(regex, "(");
        String otherNormalised = other.pattern().replaceAll(regex, "(");
        return thisNormalised.equals(otherNormalised);
    }
}

