/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.LinkedList;
import java.util.Queue;

class BackPressureHandler
extends ChannelDuplexHandler {
    static final String NAME = "pressure";
    private final Queue<Delivery> toSend = new LinkedList<Delivery>();

    BackPressureHandler() {
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!ctx.channel().isWritable()) {
            this.toSend.add(new Delivery(msg, promise));
            return;
        }
        if (this.toSend.size() > 0) {
            this.toSend.add(new Delivery(msg, promise));
            this.deliverTasks(ctx, false);
            return;
        }
        super.write(ctx, msg, promise);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.deliverTasks(ctx, true);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.deliverTasks(ctx, true);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        this.deliverTasks(ctx, false);
    }

    private void deliverTasks(ChannelHandlerContext ctx, boolean evenIfUnwriteable) {
        Delivery task;
        boolean hasSent = false;
        while ((evenIfUnwriteable || ctx.channel().isWritable()) && (task = this.toSend.poll()) != null) {
            task.send(ctx);
            hasSent = true;
        }
        if (hasSent) {
            ctx.flush();
        }
    }

    private static class Delivery {
        private final Object msg;
        private final ChannelPromise promise;

        private Delivery(Object msg, ChannelPromise promise) {
            this.msg = msg;
            this.promise = promise;
        }

        public void send(ChannelHandlerContext ctx) {
            ctx.write(this.msg, this.promise);
        }
    }
}

