/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuHandler;
import io.muserver.MuRequest;
import io.muserver.MuResponse;
import io.muserver.Mutils;
import io.muserver.NettyRequestAdapter;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ContextHandler
implements MuHandler {
    private final boolean hasContext;
    private final String contextPath;
    private final List<MuHandler> muHandlers;
    private final String slashContextSlash;
    private final String slashContext;

    ContextHandler(String contextPath, List<MuHandler> muHandlers) {
        String slashTrimmed = Mutils.trim(Mutils.coalesce(contextPath, "").trim(), "/");
        this.hasContext = !slashTrimmed.isEmpty();
        this.contextPath = Stream.of(slashTrimmed.split("/")).map(Mutils::urlEncode).collect(Collectors.joining("/"));
        this.muHandlers = muHandlers;
        this.slashContextSlash = "/" + this.contextPath + "/";
        this.slashContext = "/" + this.contextPath;
    }

    @Override
    public boolean handle(MuRequest request, MuResponse response) throws Exception {
        String rp = request.relativePath();
        if (this.hasContext && rp.equals(this.slashContext)) {
            URI cur = request.uri();
            URI newUri = cur.getRawQuery() == null ? cur.resolve(cur.getRawPath() + "/") : cur.resolve(cur.getRawPath() + "/?" + cur.getRawQuery());
            response.redirect(newUri);
            return true;
        }
        if (rp.startsWith(this.slashContextSlash) || !this.hasContext) {
            String originalContextPath = request.contextPath();
            String originalRelativePath = request.relativePath();
            if (this.hasContext) {
                ((NettyRequestAdapter)request).addContext(this.contextPath);
            }
            for (MuHandler muHandler : this.muHandlers) {
                if (!muHandler.handle(request, response)) continue;
                return true;
            }
            ((NettyRequestAdapter)request).setPaths(originalContextPath, originalRelativePath);
        }
        return false;
    }

    public String toString() {
        return "ContextHandler{context='" + this.contextPath + '\'' + ", children='" + this.muHandlers + '\'' + '}';
    }
}

