/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.Cookie;
import io.muserver.Mutils;
import io.netty.handler.codec.http.cookie.CookieHeaderNames;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CookieBuilder {
    private String name;
    private String value;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private boolean secure;
    private boolean httpOnly;
    private CookieHeaderNames.SameSite sameSite = CookieHeaderNames.SameSite.None;

    public CookieBuilder withName(String name) {
        Mutils.notNull("name", name);
        boolean matches = name.matches("^[0-9A-Za-z!#$%&'*+\\-.^_`|~]+$");
        if (!matches) {
            throw new IllegalArgumentException("A cookie name can only be alphanumeric ASCII characters or any of \"!#$%&'*+-.^_`|~\" (excluding quotes)");
        }
        this.name = name;
        return this;
    }

    public CookieBuilder withValue(String value) {
        Mutils.notNull("value", value);
        boolean matches = value.matches("^[0-9A-Za-z!#$%&'()*+\\-./:<=>?@\\[\\]^_`{|}~]*$");
        if (!matches) {
            throw new IllegalArgumentException("A cookie value can only be ASCII characters excluding control characters, whitespace, quotes, commas, semicolons and backslashes. Consider using CookieBuilder.withUrlEncodedValue instead.");
        }
        this.value = value;
        return this;
    }

    public CookieBuilder withUrlEncodedValue(String value) {
        return this.withValue(Mutils.urlEncode(value));
    }

    public CookieBuilder withDomain(String domain) {
        if (domain != null && domain.contains(":")) {
            throw new IllegalArgumentException("The domain value should only be a host name (and should not include the scheme or the port)");
        }
        this.domain = domain;
        return this;
    }

    public CookieBuilder withPath(String path) {
        this.path = path;
        return this;
    }

    public CookieBuilder withMaxAgeInSeconds(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CookieBuilder makeSessionCookie() {
        return this.withMaxAgeInSeconds(Long.MIN_VALUE);
    }

    public CookieBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public CookieBuilder httpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public CookieBuilder withSameSite(String sameSiteValue) {
        try {
            this.sameSite = CookieHeaderNames.SameSite.valueOf((String)sameSiteValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid SameSite value. It should be one of: " + Stream.of(CookieHeaderNames.SameSite.values()).map(Enum::name).collect(Collectors.joining(", ")));
        }
        return this;
    }

    public static CookieBuilder newCookie() {
        return new CookieBuilder();
    }

    public static CookieBuilder newSecureCookie() {
        return new CookieBuilder().secure(true).httpOnly(true).withSameSite("Strict");
    }

    public Cookie build() {
        if (Mutils.nullOrEmpty(this.name)) {
            throw new IllegalStateException("A cookie name must be specified");
        }
        if (this.value == null) {
            throw new IllegalStateException("A cookie value must be specified");
        }
        Cookie c = new Cookie(this.name, this.value);
        c.nettyCookie.setDomain(this.domain);
        c.nettyCookie.setPath(this.path);
        c.nettyCookie.setMaxAge(this.maxAge);
        c.nettyCookie.setSecure(this.secure);
        c.nettyCookie.setHttpOnly(this.httpOnly);
        c.nettyCookie.setSameSite(this.sameSite);
        return c;
    }
}

