/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ParseUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ForwardedHeader {
    private final String by;
    private final String forValue;
    private final String host;
    private final String proto;
    private final Map<String, String> extensions;

    public ForwardedHeader(String by, String forValue, String host, String proto, Map<String, String> extensions) {
        this.by = by;
        this.forValue = forValue;
        this.host = host;
        this.proto = proto;
        this.extensions = extensions == null ? Collections.emptyMap() : extensions;
    }

    public String by() {
        return this.by;
    }

    public String forValue() {
        return this.forValue;
    }

    public String host() {
        return this.host;
    }

    public String proto() {
        return this.proto;
    }

    public Map<String, String> extensions() {
        return this.extensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<ForwardedHeader> fromString(String input) {
        if (input == null || input.trim().isEmpty()) {
            return Collections.emptyList();
        }
        StringBuilder buffer = new StringBuilder();
        ArrayList<ForwardedHeader> results = new ArrayList<ForwardedHeader>();
        int i = 0;
        while (i < input.length()) {
            LinkedHashMap<String, String> extensions = null;
            State state = State.PARAM_NAME;
            String paramName = null;
            String by = null;
            String forValue = null;
            String host = null;
            String proto = null;
            boolean isQuotedString = false;
            while (i < input.length()) {
                char c = input.charAt(i);
                if (state == State.PARAM_NAME) {
                    if (c == ',' && buffer.length() == 0) {
                        ++i;
                        break;
                    }
                    if (c == '=') {
                        paramName = buffer.toString();
                        buffer.setLength(0);
                        state = State.PARAM_VALUE;
                    } else if (ParseUtils.isTChar(c)) {
                        buffer.append(c);
                    } else {
                        if (!ParseUtils.isOWS(c)) throw new IllegalArgumentException("Got ascii " + c + " while in " + (Object)((Object)state));
                        if (buffer.length() > 0) {
                            throw new IllegalArgumentException("Got whitespace in parameter name while in " + (Object)((Object)state) + " - header was " + buffer);
                        }
                    }
                } else {
                    boolean isFirst;
                    boolean bl = isFirst = !isQuotedString && buffer.length() == 0;
                    if (!isFirst || !ParseUtils.isOWS(c)) {
                        if (isFirst && c == '\"') {
                            isQuotedString = true;
                        } else if (isQuotedString) {
                            char lastChar = input.charAt(i - 1);
                            if (c != '\\') {
                                if (lastChar == '\\') {
                                    buffer.append(c);
                                } else if (c == '\"') {
                                    isQuotedString = false;
                                } else {
                                    buffer.append(c);
                                }
                            }
                        } else if (c == ';') {
                            String val = buffer.toString();
                            switch (paramName.toLowerCase()) {
                                case "by": {
                                    by = val;
                                    break;
                                }
                                case "for": {
                                    forValue = val;
                                    break;
                                }
                                case "host": {
                                    host = val;
                                    break;
                                }
                                case "proto": {
                                    proto = val;
                                    break;
                                }
                                default: {
                                    if (extensions == null) {
                                        extensions = new LinkedHashMap();
                                    }
                                    extensions.put(paramName, val);
                                }
                            }
                            buffer.setLength(0);
                            paramName = null;
                            state = State.PARAM_NAME;
                        } else {
                            if (c == ',') {
                                ++i;
                                break;
                            }
                            if (ParseUtils.isVChar(c)) {
                                buffer.append(c);
                            } else if (!ParseUtils.isOWS(c)) {
                                throw new IllegalArgumentException("Got character code " + c + " (" + c + ") while parsing parameter value");
                            }
                        }
                    }
                }
                ++i;
            }
            switch (state) {
                case PARAM_VALUE: {
                    String val = buffer.toString();
                    switch (paramName.toLowerCase()) {
                        case "by": {
                            by = val;
                            break;
                        }
                        case "for": {
                            forValue = val;
                            break;
                        }
                        case "host": {
                            host = val;
                            break;
                        }
                        case "proto": {
                            proto = val;
                            break;
                        }
                        default: {
                            if (extensions == null) {
                                extensions = new LinkedHashMap<String, String>();
                            }
                            extensions.put(paramName, val);
                        }
                    }
                    buffer.setLength(0);
                    break;
                }
                default: {
                    if (buffer.length() <= 0) break;
                    throw new IllegalArgumentException("Unexpected ending point at state " + (Object)((Object)state) + " for " + input);
                }
            }
            results.add(new ForwardedHeader(by, forValue, host, proto, extensions));
        }
        return results;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ForwardedHeader.appendString(sb, "by", this.by);
        ForwardedHeader.appendString(sb, "for", this.forValue);
        ForwardedHeader.appendString(sb, "host", this.host);
        ForwardedHeader.appendString(sb, "proto", this.proto);
        this.extensions().forEach((key, value) -> ForwardedHeader.appendString(sb, key, value));
        return sb.toString();
    }

    public static String toString(List<ForwardedHeader> headers) {
        StringBuilder sb = new StringBuilder();
        for (ForwardedHeader header : headers) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(header.toString());
        }
        return sb.toString();
    }

    private static void appendString(StringBuilder sb, String key, String value) {
        if (value == null) {
            return;
        }
        if (sb.length() > 0) {
            sb.append(';');
        }
        sb.append(key).append('=').append(ParseUtils.quoteIfNeeded(value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForwardedHeader that = (ForwardedHeader)o;
        return Objects.equals(this.by, that.by) && Objects.equals(this.forValue, that.forValue) && Objects.equals(this.host, that.host) && Objects.equals(this.proto, that.proto) && this.extensions.equals(that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.by, this.forValue, this.host, this.proto, this.extensions);
    }

    private static enum State {
        PARAM_NAME,
        PARAM_VALUE;

    }
}

