/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ContentTypes;
import io.muserver.Exchange;
import io.muserver.ExchangeUpgradeEvent;
import io.muserver.HeaderNames;
import io.muserver.HttpConnection;
import io.muserver.HttpExchange;
import io.muserver.HttpExchangeState;
import io.muserver.InvalidHttpRequestException;
import io.muserver.MuExceptionFiredEvent;
import io.muserver.MuRequest;
import io.muserver.MuServer;
import io.muserver.MuServerImpl;
import io.muserver.MuStatsImpl;
import io.muserver.MuWebSocket;
import io.muserver.MuWebSocketSessionImpl;
import io.muserver.Mutils;
import io.muserver.NettyHandlerAdapter;
import io.muserver.ProxiedConnectionInfo;
import io.muserver.ProxiedConnectionInfoImpl;
import io.muserver.RedirectException;
import io.muserver.RequestState;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http1Connection
extends SimpleChannelInboundHandler<Object>
implements HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1Connection.class);
    private final NettyHandlerAdapter nettyHandlerAdapter;
    private final MuStatsImpl serverStats;
    private final MuStatsImpl connectionStats = new MuStatsImpl(null);
    private final MuServerImpl server;
    private final String proto;
    private final Instant startTime = Instant.now();
    private ChannelHandlerContext nettyCtx;
    private InetSocketAddress remoteAddress;
    private Exchange currentExchange = null;
    private ProxiedConnectionInfo proxyInfo;

    Http1Connection(NettyHandlerAdapter nettyHandlerAdapter, MuServerImpl server, String proto) {
        this.nettyHandlerAdapter = nettyHandlerAdapter;
        this.serverStats = server.stats;
        this.server = server;
        this.proto = proto;
    }

    static SSLSession getSslSession(ChannelHandlerContext ctx) {
        SslHandler ssl = (SslHandler)ctx.channel().pipeline().get("ssl");
        return ssl.engine().getSession();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.nettyCtx = ctx;
        this.remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        this.serverStats.onConnectionOpened();
        this.connectionStats.onConnectionOpened();
        super.handlerAdded(ctx);
        this.server.onConnectionStarted(this);
        ctx.channel().read();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.serverStats.onConnectionClosed();
        this.server.onConnectionEnded(this);
        if (this.currentExchange != null) {
            this.currentExchange.onConnectionEnded(ctx);
        }
        super.channelInactive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        try {
            this.onChannelRead(ctx, msg);
        }
        catch (Exception e) {
            log.warn("Unhandled internal error. Closing connection.", (Throwable)e);
            ctx.channel().close();
        }
    }

    private void onChannelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HAProxyMessage) {
            HAProxyMessage hap = (HAProxyMessage)msg;
            this.proxyInfo = ProxiedConnectionInfoImpl.fromNetty(hap);
            ctx.channel().read();
        } else if (msg instanceof HttpRequest) {
            try {
                this.currentExchange = HttpExchange.create(this.server, this.proto, ctx, this, (HttpRequest)msg, this.nettyHandlerAdapter, this.connectionStats, (exchange, newState) -> {
                    if (newState == RequestState.RECEIVING_BODY) {
                        ctx.channel().read();
                    }
                }, (exchange, newState) -> {
                    if (newState.endState()) {
                        this.nettyHandlerAdapter.onResponseComplete(exchange, this.serverStats, this.connectionStats);
                        ctx.channel().eventLoop().execute(() -> {
                            if (exchange.state() != HttpExchangeState.UPGRADED) {
                                if (this.currentExchange != exchange) {
                                    throw new IllegalStateException("Expected current exchange to be " + exchange + " but was " + this.currentExchange);
                                }
                                this.currentExchange = null;
                                exchange.request.cleanup();
                                if (exchange.state() == HttpExchangeState.ERRORED) {
                                    ctx.channel().close();
                                } else {
                                    ctx.channel().read();
                                }
                            }
                        });
                    }
                });
            }
            catch (InvalidHttpRequestException ihr) {
                if (ihr.code == 429 || ihr.code == 503) {
                    this.connectionStats.onRejectedDueToOverload();
                    this.serverStats.onRejectedDueToOverload();
                } else {
                    this.connectionStats.onInvalidRequest();
                    this.serverStats.onInvalidRequest();
                }
                Http1Connection.sendSimpleResponse(ctx, ihr.getMessage(), ihr.code);
                ctx.channel().read();
            }
            catch (RedirectException e) {
                Http1Connection.sendRedirect(ctx, e.location);
            }
        } else if (this.currentExchange != null) {
            this.currentExchange.onMessage(ctx, msg, error -> {
                if (error == null) {
                    if (!(msg instanceof LastHttpContent)) {
                        ctx.channel().read();
                    }
                } else {
                    ctx.fireUserEventTriggered((Object)new MuExceptionFiredEvent(this.currentExchange, -1, error));
                }
            });
        } else {
            log.debug("Got a chunk of message for an unknown request. This can happen when a request is rejected based on headers, and then the rejected body arrives.");
            ctx.channel().read();
        }
    }

    private static ChannelFuture sendSimpleResponse(ChannelHandlerContext ctx, String message, int code) {
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)code), Unpooled.copiedBuffer((byte[])bytes));
        response.headers().set(HeaderNames.DATE, (Object)Mutils.toHttpDate(new Date()));
        response.headers().set(HeaderNames.CONTENT_TYPE, (Object)ContentTypes.TEXT_PLAIN_UTF8);
        response.headers().set(HeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        return ctx.writeAndFlush((Object)response);
    }

    private static ChannelFuture sendRedirect(ChannelHandlerContext ctx, URI location) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)302));
        response.headers().set(HeaderNames.DATE, (Object)Mutils.toHttpDate(new Date()));
        response.headers().set(HeaderNames.LOCATION, (Object)location.toString());
        return ctx.writeAndFlush((Object)response);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        Exchange exchange = this.currentExchange;
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent ise = (IdleStateEvent)evt;
            if (exchange != null) {
                exchange.onIdleTimeout(ctx, ise);
            } else if (ise.state() == IdleState.ALL_IDLE) {
                ctx.channel().close();
                log.info("Closed idle connection to " + this.remoteAddress);
            }
        } else if (evt instanceof ExchangeUpgradeEvent) {
            ExchangeUpgradeEvent eue = (ExchangeUpgradeEvent)evt;
            if (eue.success()) {
                if (this.currentExchange instanceof HttpExchange) {
                    HttpExchange httpExchange = (HttpExchange)this.currentExchange;
                    httpExchange.addChangeListener((upgradeExchange, newState) -> {
                        if (newState == HttpExchangeState.UPGRADED) {
                            this.currentExchange = eue.newExchange;
                            this.currentExchange.onUpgradeComplete(ctx);
                            ctx.channel().read();
                        } else if (newState == HttpExchangeState.ERRORED) {
                            eue.newExchange.onConnectionEnded(ctx);
                        }
                    });
                    httpExchange.response.setWebsocket();
                } else {
                    this.currentExchange = eue.newExchange;
                }
                ctx.channel().read();
            } else {
                ctx.channel().close();
            }
        } else if (evt instanceof MuExceptionFiredEvent) {
            MuExceptionFiredEvent mefe = (MuExceptionFiredEvent)evt;
            this.exceptionCaught(ctx, mefe.error);
        }
        super.userEventTriggered(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Exchange exchange = this.currentExchange;
        if (exchange != null) {
            if (exchange.onException(ctx, cause)) {
                ctx.channel().close();
            }
        } else {
            ctx.channel().close();
        }
    }

    @Override
    public String protocol() {
        return "HTTP/1.1";
    }

    @Override
    public boolean isHttps() {
        return "https".equals(this.proto);
    }

    @Override
    public String httpsProtocol() {
        return this.isHttps() ? Http1Connection.getSslSession(this.nettyCtx).getProtocol() : null;
    }

    @Override
    public String cipher() {
        return this.isHttps() ? Http1Connection.getSslSession(this.nettyCtx).getCipherSuite() : null;
    }

    @Override
    public Instant startTime() {
        return this.startTime;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public long completedRequests() {
        return this.connectionStats.completedRequests();
    }

    @Override
    public long invalidHttpRequests() {
        return this.connectionStats.invalidHttpRequests();
    }

    @Override
    public long rejectedDueToOverload() {
        return this.connectionStats.rejectedDueToOverload();
    }

    @Override
    public Set<MuRequest> activeRequests() {
        Exchange currentExchange = this.currentExchange;
        return currentExchange instanceof HttpExchange ? Collections.singleton(((HttpExchange)currentExchange).request) : Collections.emptySet();
    }

    @Override
    public Set<MuWebSocket> activeWebsockets() {
        Exchange currentExchange = this.currentExchange;
        return currentExchange instanceof MuWebSocketSessionImpl ? Collections.singleton(((MuWebSocketSessionImpl)currentExchange).muWebSocket) : Collections.emptySet();
    }

    @Override
    public MuServer server() {
        return this.server;
    }

    @Override
    public Optional<Certificate> clientCertificate() {
        return Http1Connection.fromContext(this.nettyCtx);
    }

    @Override
    public Optional<ProxiedConnectionInfo> proxyInfo() {
        return Optional.ofNullable(this.proxyInfo);
    }

    static Optional<Certificate> fromContext(ChannelHandlerContext channelHandlerContext) {
        try {
            SslHandler sslhandler = (SslHandler)channelHandlerContext.channel().pipeline().get("ssl");
            if (sslhandler == null) {
                return Optional.empty();
            }
            SSLSession session = sslhandler.engine().getSession();
            return Optional.of(session.getPeerCertificates()[0]);
        }
        catch (SSLPeerUnverifiedException e) {
            return Optional.empty();
        }
    }
}

