/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.ForwardedHeader;
import io.muserver.HeaderNames;
import io.muserver.Headers;
import io.muserver.Headtils;
import io.muserver.Mutils;
import io.muserver.NettyRequestParameters;
import io.muserver.ParameterizedHeader;
import io.muserver.ParameterizedHeaderWithValue;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.util.internal.ObjectUtil;
import jakarta.ws.rs.core.MediaType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class Http2Headers
implements Headers {
    final io.netty.handler.codec.http2.Http2Headers entries;
    private final boolean hasRequestBody;

    Http2Headers() {
        this((io.netty.handler.codec.http2.Http2Headers)new DefaultHttp2Headers(), false);
    }

    Http2Headers(io.netty.handler.codec.http2.Http2Headers entries, boolean hasRequestBody) {
        this.entries = entries;
        this.hasRequestBody = hasRequestBody;
    }

    private static CharSequence toLower(CharSequence name) {
        Mutils.notNull("name", name);
        if (name instanceof String) {
            return ((String)name).toLowerCase();
        }
        return name;
    }

    @Override
    public String get(String name) {
        return this.get((CharSequence)name);
    }

    @Override
    public String get(CharSequence name) {
        CharSequence val = (CharSequence)this.entries.get((Object)Http2Headers.toLower(name));
        return val == null ? null : val.toString();
    }

    @Override
    public String get(CharSequence name, String defaultValue) {
        CharSequence val = (CharSequence)this.entries.get((Object)Http2Headers.toLower(name), (Object)defaultValue);
        return val == null ? null : val.toString();
    }

    @Override
    public int getInt(CharSequence name, int defaultValue) {
        return this.entries.getInt((Object)Http2Headers.toLower(name), defaultValue);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Long.parseLong(stringVal, 10);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Float.parseFloat(stringVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        try {
            String stringVal = this.get(name, null);
            if (stringVal == null) {
                return defaultValue;
            }
            return Double.parseDouble(stringVal);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String name) {
        String val = this.get(name, "").toLowerCase();
        return NettyRequestParameters.isTruthy(val);
    }

    @Override
    public Long getTimeMillis(CharSequence name) {
        return this.entries.getTimeMillis((Object)Http2Headers.toLower(name));
    }

    @Override
    public long getTimeMillis(CharSequence name, long defaultValue) {
        return this.entries.getTimeMillis((Object)Http2Headers.toLower(name), defaultValue);
    }

    @Override
    public List<String> getAll(String name) {
        return this.getAll((CharSequence)name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.entries.getAll((Object)Http2Headers.toLower(name)).stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        ArrayList<Map.Entry<String, String>> all = new ArrayList<Map.Entry<String, String>>(this.size());
        for (Map.Entry<String, String> e : this) {
            all.add(e);
        }
        return all;
    }

    @Override
    public boolean contains(String name) {
        return this.contains((CharSequence)name);
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.entries.contains((Object)Http2Headers.toLower(name));
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        Iterator it = this.entries.iterator();
        return Stream.generate(it::next).limit(this.entries.size()).filter(e -> ((CharSequence)e.getKey()).charAt(0) != ':').map(e -> new AbstractMap.SimpleImmutableEntry<String, String>(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Set<String> names() {
        return this.entries.names().stream().filter(name -> name.charAt(0) != ':').map(CharSequence::toString).collect(Collectors.toSet());
    }

    @Override
    public Headers add(String name, Object value) {
        return this.add((CharSequence)name, value);
    }

    @Override
    public Headers add(CharSequence name, Object value) {
        this.entries.addObject((Object)Http2Headers.toLower(name), value);
        return this;
    }

    @Override
    public Headers add(String name, Iterable<?> values) {
        return this.add((CharSequence)name, values);
    }

    @Override
    public Headers add(CharSequence name, Iterable<?> values) {
        name = Http2Headers.toLower(name);
        for (Object value : values) {
            this.entries.addObject((Object)name, value);
        }
        return this;
    }

    @Override
    public Headers add(Headers headers) {
        for (Map.Entry<String, String> e : headers) {
            this.add(e.getKey(), (Object)e.getValue());
        }
        return this;
    }

    @Override
    public Headers addInt(CharSequence name, int value) {
        this.entries.addInt((Object)Http2Headers.toLower(name), value);
        return this;
    }

    @Override
    public Headers set(String name, Object value) {
        return this.set((CharSequence)name, value);
    }

    @Override
    public Headers set(CharSequence name, Object value) {
        this.entries.setObject((Object)Http2Headers.toLower(name), value);
        return this;
    }

    @Override
    public Headers set(String name, Iterable<?> values) {
        return this.set((CharSequence)name, values);
    }

    @Override
    public Headers set(CharSequence name, Iterable<?> values) {
        name = Http2Headers.toLower(name);
        this.entries.remove((Object)name);
        return this.add(name, values);
    }

    @Override
    public Headers set(Headers headers) {
        ObjectUtil.checkNotNull((Object)headers, (String)"headers");
        this.clear();
        for (Map.Entry<String, String> entry : headers) {
            this.add(entry.getKey(), (Object)entry.getValue());
        }
        return this;
    }

    @Override
    public Headers setAll(Headers headers) {
        ObjectUtil.checkNotNull((Object)headers, (String)"headers");
        for (String name : headers.names()) {
            this.set(name, (Iterable<?>)headers.getAll(name));
        }
        return this;
    }

    @Override
    public Headers setInt(CharSequence name, int value) {
        this.entries.setInt((Object)Http2Headers.toLower(name), value);
        return this;
    }

    @Override
    public Headers remove(String name) {
        return this.remove((CharSequence)name);
    }

    @Override
    public Headers remove(CharSequence name) {
        this.entries.remove((Object)Http2Headers.toLower(name));
        return this;
    }

    @Override
    public Headers clear() {
        this.entries.clear();
        return this;
    }

    @Override
    public boolean contains(String name, String value, boolean ignoreCase) {
        return this.contains((CharSequence)name, (CharSequence)value, ignoreCase);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.entries.contains(Http2Headers.toLower(name), value, ignoreCase);
    }

    @Override
    public boolean containsValue(CharSequence name, CharSequence value, boolean ignoreCase) {
        return this.entries.contains(Http2Headers.toLower(name), value, ignoreCase);
    }

    public boolean equals(Object o) {
        return this.entries.equals(o);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public String toString() {
        return Headtils.toString(this, null);
    }

    @Override
    public String toString(Collection<String> toSuppress) {
        return Headtils.toString(this, toSuppress);
    }

    @Override
    public boolean hasBody() {
        return this.hasRequestBody;
    }

    @Override
    public List<ParameterizedHeaderWithValue> accept() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT);
    }

    @Override
    public List<ParameterizedHeaderWithValue> acceptCharset() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT_CHARSET);
    }

    @Override
    public List<ParameterizedHeaderWithValue> acceptEncoding() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT_ENCODING);
    }

    @Override
    public List<ForwardedHeader> forwarded() {
        return Headtils.getForwardedHeaders(this);
    }

    @Override
    public List<ParameterizedHeaderWithValue> acceptLanguage() {
        return Headtils.getParameterizedHeaderWithValues(this, HeaderNames.ACCEPT_LANGUAGE);
    }

    @Override
    public ParameterizedHeader cacheControl() {
        return ParameterizedHeader.fromString(this.get(HeaderNames.CACHE_CONTROL));
    }

    @Override
    public MediaType contentType() {
        return Headtils.getMediaType(this);
    }
}

