/*
 * Decompiled with CFR 0.152.
 */
package io.muserver;

import io.muserver.MuException;
import io.muserver.Mutils;
import io.muserver.SSLCipherFilter;
import io.muserver.SniKeyManager;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpsConfigBuilder.class);
    private String[] protocols = null;
    private String keystoreType = "JKS";
    private char[] keystorePassword = new char[0];
    private char[] keyPassword = new char[0];
    private byte[] keystoreBytes;
    private SSLContext sslContext;
    private CipherSuiteFilter nettyCipherSuiteFilter;
    private KeyManagerFactory keyManagerFactory;
    private String defaultAlias;
    protected TrustManager trustManager;

    public HttpsConfigBuilder withKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
        return this;
    }

    public HttpsConfigBuilder withKeyPassword(String keyPassword) {
        return this.withKeyPassword(keyPassword.toCharArray());
    }

    public HttpsConfigBuilder withKeystorePassword(String keystorePassword) {
        return this.withKeystorePassword(keystorePassword.toCharArray());
    }

    public HttpsConfigBuilder withKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    public HttpsConfigBuilder withKeystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    HttpsConfigBuilder withSSLContext(SSLContext sslContext) {
        this.keyManagerFactory = null;
        this.sslContext = sslContext;
        return this;
    }

    protected void setKeystoreBytes(InputStream is, boolean closeAfter) {
        this.sslContext = null;
        this.keyManagerFactory = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Mutils.copy(is, baos, 8192);
            this.keystoreBytes = baos.toByteArray();
        }
        catch (IOException e) {
            throw new MuException("Error while loading keystore", e);
        }
        finally {
            if (closeAfter) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warn("Error while closing stream after reading SSL input stream", (Throwable)e);
                }
            }
        }
    }

    public HttpsConfigBuilder withKeystore(InputStream keystoreStream) {
        this.setKeystoreBytes(keystoreStream, false);
        return this;
    }

    public HttpsConfigBuilder withKeystore(File file) {
        FileInputStream fis;
        if (!file.isFile()) {
            throw new IllegalArgumentException(Mutils.fullPath(file) + " does not exist");
        }
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Could not open file", e);
        }
        this.setKeystoreBytes(fis, true);
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public HttpsConfigBuilder withKeystore(KeyStore keystore, char[] password) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            HttpsConfigBuilder httpsConfigBuilder;
            keystore.store(baos, password);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());){
                httpsConfigBuilder = this.withKeystore(inputStream).withKeystorePassword(password).withKeyPassword(password);
            }
            return httpsConfigBuilder;
        }
        catch (Exception e) {
            throw new MuException("Error loading KeyStore into memory", e);
        }
    }

    public HttpsConfigBuilder withKeystoreFromClasspath(String classpath) {
        InputStream keystoreStream = HttpsConfigBuilder.class.getResourceAsStream(classpath);
        if (keystoreStream == null) {
            throw new IllegalArgumentException("Could not find " + classpath);
        }
        this.setKeystoreBytes(keystoreStream, true);
        return this;
    }

    public HttpsConfigBuilder withKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keystoreBytes = null;
        this.sslContext = null;
        this.keyManagerFactory = keyManagerFactory;
        return this;
    }

    public HttpsConfigBuilder withCipherFilter(SSLCipherFilter cipherFilter) {
        this.nettyCipherSuiteFilter = cipherFilter == null ? null : (ciphers, defaultCiphers, supportedCiphers) -> {
            List selected = cipherFilter.selectCiphers(supportedCiphers, defaultCiphers);
            if (selected == null) {
                selected = defaultCiphers;
            }
            return selected.toArray(new String[0]);
        };
        return this;
    }

    public HttpsConfigBuilder withProtocols(String ... protocols) {
        this.protocols = protocols;
        return this;
    }

    public HttpsConfigBuilder withDefaultAlias(String certAlias) {
        this.defaultAlias = certAlias;
        return this;
    }

    SSLContext build() {
        if (this.keystoreBytes == null) {
            throw new MuException("No keystore has been set");
        }
        ByteArrayInputStream keystoreStream = new ByteArrayInputStream(this.keystoreBytes);
        try {
            SSLContext serverContext = SSLContext.getInstance("TLS");
            KeyStore ks = KeyStore.getInstance(this.keystoreType);
            ks.load(keystoreStream, this.keystorePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, this.keyPassword);
            serverContext.init(kmf.getKeyManagers(), null, null);
            SSLContext sSLContext = serverContext;
            return sSLContext;
        }
        catch (Exception e) {
            throw new MuException("Error while setting up SSLContext", e);
        }
        finally {
            try {
                keystoreStream.close();
            }
            catch (IOException e) {
                log.info("Error while closing keystore stream: " + e.getMessage());
            }
        }
    }

    static Map<String, String> buildSanToAliasMap(KeyStore keyStore) throws KeyStoreException {
        HashMap<String, String> sanToAliasMap = new HashMap<String, String>();
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = keyStore.getCertificate(alias);
            if (!(certificate instanceof X509Certificate)) continue;
            List<String> sans = HttpsConfigBuilder.getDNSSubjectAlternativeNames((X509Certificate)certificate);
            for (String san : sans) {
                sanToAliasMap.put(san, alias);
            }
        }
        return sanToAliasMap;
    }

    static List<String> getDNSSubjectAlternativeNames(X509Certificate cert) {
        try {
            Collection<List<?>> subjectAlternativeNames = cert.getSubjectAlternativeNames();
            if (subjectAlternativeNames == null) {
                return Collections.emptyList();
            }
            return subjectAlternativeNames.stream().filter(objects -> objects.size() == 2 && objects.get(0) instanceof Integer && objects.get(1) instanceof String && objects.get(0).equals(2)).map(objects -> (String)objects.get(1)).collect(Collectors.toList());
        }
        catch (CertificateParsingException e) {
            log.warn("Can't get subject alternative names from cert {}", (Object)cert);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SslContext toNettySslContext(boolean http2) throws Exception {
        SslContextBuilder builder;
        ClientAuth clientAuthSetting;
        IdentityCipherSuiteFilter cipherFilter = this.nettyCipherSuiteFilter != null ? this.nettyCipherSuiteFilter : IdentityCipherSuiteFilter.INSTANCE;
        ClientAuth clientAuth = clientAuthSetting = this.trustManager == null ? ClientAuth.NONE : ClientAuth.OPTIONAL;
        if (this.sslContext != null) {
            return new JdkSslContext(this.sslContext, false, null, (CipherSuiteFilter)cipherFilter, ApplicationProtocolConfig.DISABLED, clientAuthSetting, this.getHttpsProtocolsArray(), false);
        }
        if (this.keystoreBytes != null) {
            KeyManagerFactory kmf;
            ByteArrayInputStream keystoreStream = new ByteArrayInputStream(this.keystoreBytes);
            String defaultAliasToUse = this.defaultAlias;
            HashMap<String, String> sanToAliasMap = new HashMap<String, String>();
            try {
                KeyStore ks = KeyStore.getInstance(this.keystoreType);
                ks.load(keystoreStream, this.keystorePassword);
                if (defaultAliasToUse == null) {
                    KeyManager[] aliases = ks.aliases();
                    while (aliases.hasMoreElements() && defaultAliasToUse == null) {
                        String al = aliases.nextElement();
                        if (!ks.isKeyEntry(al)) continue;
                        defaultAliasToUse = al;
                    }
                }
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, this.keyPassword);
                sanToAliasMap.putAll(HttpsConfigBuilder.buildSanToAliasMap(ks));
                log.debug("keystore san to alias mapping: {}", sanToAliasMap);
            }
            finally {
                try {
                    keystoreStream.close();
                }
                catch (IOException e) {
                    log.info("Error while closing keystore stream: " + e.getMessage());
                }
            }
            X509ExtendedKeyManager x509KeyManager = null;
            for (KeyManager keyManager : kmf.getKeyManagers()) {
                if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                x509KeyManager = (X509ExtendedKeyManager)keyManager;
            }
            if (x509KeyManager == null) {
                throw new Exception("KeyManagerFactory did not create an X509ExtendedKeyManager");
            }
            SniKeyManager sniKeyManager = new SniKeyManager(x509KeyManager, defaultAliasToUse, sanToAliasMap);
            builder = SslContextBuilder.forServer((KeyManager)sniKeyManager);
        } else if (this.keyManagerFactory != null) {
            builder = SslContextBuilder.forServer((KeyManagerFactory)this.keyManagerFactory);
        } else {
            throw new IllegalStateException("No SSL info");
        }
        if (http2) {
            builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
        }
        String[] protocolsArray = this.getHttpsProtocolsArray();
        if (this.trustManager != null) {
            builder.trustManager(this.trustManager);
        }
        return builder.clientAuth(clientAuthSetting).protocols(protocolsArray).ciphers(null, (CipherSuiteFilter)cipherFilter).build();
    }

    private String[] getHttpsProtocolsArray() throws NoSuchAlgorithmException {
        List<String> supportedProtocols = Arrays.asList(SSLContext.getDefault().getSupportedSSLParameters().getProtocols());
        ArrayList<String> protocolsToUse = new ArrayList<String>();
        for (String protocol : (String[])Mutils.coalesce(this.protocols, {"TLSv1.2", "TLSv1.3"})) {
            if (supportedProtocols.contains(protocol)) {
                protocolsToUse.add(protocol);
                continue;
            }
            log.warn("Will not use " + protocol + " as it is not supported by the current JDK");
        }
        if (protocolsToUse.isEmpty()) {
            throw new MuException("Cannot start up as none of the requested SSL protocols " + Arrays.toString(this.protocols) + " are supported by the current JDK " + supportedProtocols);
        }
        String[] protocolsArray = protocolsToUse.toArray(new String[0]);
        return protocolsArray;
    }

    public static HttpsConfigBuilder httpsConfig() {
        return new HttpsConfigBuilder();
    }

    public HttpsConfigBuilder withClientCertificateTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public static HttpsConfigBuilder unsignedLocalhost() {
        return HttpsConfigBuilder.httpsConfig().withKeystoreType("PKCS12").withKeystorePassword("Very5ecure").withKeyPassword("Very5ecure").withKeystoreFromClasspath("/io/muserver/resources/localhost.p12");
    }
}

